/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.com.google.common.collect.SortedIterable;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.util.Comparator;
import io.logz.sender.java.util.SortedSet;

@GwtCompatible
final class SortedIterables
extends io.logz.sender.java.lang.Object {
    private SortedIterables() {
    }

    public static boolean hasSameComparator(Comparator<?> comparator, Iterable<?> elements) {
        Object comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elements);
        if (elements instanceof SortedSet) {
            comparator2 = SortedIterables.comparator((SortedSet)elements);
        } else if (elements instanceof SortedIterable) {
            comparator2 = ((SortedIterable)elements).comparator();
        } else {
            return false;
        }
        return comparator.equals(comparator2);
    }

    public static <E extends io.logz.sender.java.lang.Object> Comparator<? super E> comparator(SortedSet<E> sortedSet) {
        Ordering result = sortedSet.comparator();
        if (result == null) {
            result = Ordering.natural();
        }
        return result;
    }
}

