/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.hash;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.hash.AbstractCompositeHashFunction;
import io.logz.sender.com.google.common.hash.ChecksumHashFunction;
import io.logz.sender.com.google.common.hash.Crc32cHashFunction;
import io.logz.sender.com.google.common.hash.FarmHashFingerprint64;
import io.logz.sender.com.google.common.hash.HashCode;
import io.logz.sender.com.google.common.hash.HashFunction;
import io.logz.sender.com.google.common.hash.Hasher;
import io.logz.sender.com.google.common.hash.ImmutableSupplier;
import io.logz.sender.com.google.common.hash.MacHashFunction;
import io.logz.sender.com.google.common.hash.MessageDigestHashFunction;
import io.logz.sender.com.google.common.hash.Murmur3_128HashFunction;
import io.logz.sender.com.google.common.hash.Murmur3_32HashFunction;
import io.logz.sender.com.google.common.hash.SipHashFunction;
import io.logz.sender.com.google.errorprone.annotations.Immutable;
import io.logz.sender.java.lang.Deprecated;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.System;
import io.logz.sender.java.security.Key;
import io.logz.sender.java.util.ArrayList;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.zip.Adler32;
import io.logz.sender.java.util.zip.CRC32;
import io.logz.sender.java.util.zip.Checksum;
import io.logz.sender.javax.crypto.spec.SecretKeySpec;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Beta
public final class Hashing
extends io.logz.sender.java.lang.Object {
    static final int GOOD_FAST_HASH_SEED = (int)System.currentTimeMillis();

    public static HashFunction goodFastHash(int minimumBits) {
        int bits = Hashing.checkPositiveAndMakeMultipleOf32(minimumBits);
        if (bits == 32) {
            return Murmur3_32HashFunction.GOOD_FAST_HASH_32;
        }
        if (bits <= 128) {
            return Murmur3_128HashFunction.GOOD_FAST_HASH_128;
        }
        int hashFunctionsNeeded = (bits + 127) / 128;
        HashFunction[] hashFunctions = new HashFunction[hashFunctionsNeeded];
        hashFunctions[0] = Murmur3_128HashFunction.GOOD_FAST_HASH_128;
        int seed = GOOD_FAST_HASH_SEED;
        for (int i = 1; i < hashFunctionsNeeded; ++i) {
            hashFunctions[i] = Hashing.murmur3_128(seed += 1500450271);
        }
        return new ConcatenatedHashFunction(hashFunctions);
    }

    public static HashFunction murmur3_32(int seed) {
        return new Murmur3_32HashFunction(seed);
    }

    public static HashFunction murmur3_32() {
        return Murmur3_32HashFunction.MURMUR3_32;
    }

    public static HashFunction murmur3_128(int seed) {
        return new Murmur3_128HashFunction(seed);
    }

    public static HashFunction murmur3_128() {
        return Murmur3_128HashFunction.MURMUR3_128;
    }

    public static HashFunction sipHash24() {
        return SipHashFunction.SIP_HASH_24;
    }

    public static HashFunction sipHash24(long k0, long k1) {
        return new SipHashFunction(2, 4, k0, k1);
    }

    @Deprecated
    public static HashFunction md5() {
        return Md5Holder.MD5;
    }

    @Deprecated
    public static HashFunction sha1() {
        return Sha1Holder.SHA_1;
    }

    public static HashFunction sha256() {
        return Sha256Holder.SHA_256;
    }

    public static HashFunction sha384() {
        return Sha384Holder.SHA_384;
    }

    public static HashFunction sha512() {
        return Sha512Holder.SHA_512;
    }

    public static HashFunction hmacMd5(Key key) {
        return new MacHashFunction((String)"io.logz.sender.HmacMD5", key, Hashing.hmacToString((String)"io.logz.sender.hmacMd5", key));
    }

    public static HashFunction hmacMd5(byte[] key) {
        return Hashing.hmacMd5((Key)new SecretKeySpec(Preconditions.checkNotNull(key), (String)"io.logz.sender.HmacMD5"));
    }

    public static HashFunction hmacSha1(Key key) {
        return new MacHashFunction((String)"io.logz.sender.HmacSHA1", key, Hashing.hmacToString((String)"io.logz.sender.hmacSha1", key));
    }

    public static HashFunction hmacSha1(byte[] key) {
        return Hashing.hmacSha1((Key)new SecretKeySpec(Preconditions.checkNotNull(key), (String)"io.logz.sender.HmacSHA1"));
    }

    public static HashFunction hmacSha256(Key key) {
        return new MacHashFunction((String)"io.logz.sender.HmacSHA256", key, Hashing.hmacToString((String)"io.logz.sender.hmacSha256", key));
    }

    public static HashFunction hmacSha256(byte[] key) {
        return Hashing.hmacSha256((Key)new SecretKeySpec(Preconditions.checkNotNull(key), (String)"io.logz.sender.HmacSHA256"));
    }

    public static HashFunction hmacSha512(Key key) {
        return new MacHashFunction((String)"io.logz.sender.HmacSHA512", key, Hashing.hmacToString((String)"io.logz.sender.hmacSha512", key));
    }

    public static HashFunction hmacSha512(byte[] key) {
        return Hashing.hmacSha512((Key)new SecretKeySpec(Preconditions.checkNotNull(key), (String)"io.logz.sender.HmacSHA512"));
    }

    private static String hmacToString(String methodName, Key key) {
        return String.format((String)"io.logz.sender.Hashing.%s(Key[algorithm=%s, format=%s])", (io.logz.sender.java.lang.Object[])new io.logz.sender.java.lang.Object[]{methodName, key.getAlgorithm(), key.getFormat()});
    }

    public static HashFunction crc32c() {
        return Crc32cHashFunction.CRC_32_C;
    }

    public static HashFunction crc32() {
        return ChecksumType.CRC_32.hashFunction;
    }

    public static HashFunction adler32() {
        return ChecksumType.ADLER_32.hashFunction;
    }

    public static HashFunction farmHashFingerprint64() {
        return FarmHashFingerprint64.FARMHASH_FINGERPRINT_64;
    }

    public static int consistentHash(HashCode hashCode, int buckets) {
        return Hashing.consistentHash(hashCode.padToLong(), buckets);
    }

    public static int consistentHash(long input, int buckets) {
        int next;
        Preconditions.checkArgument(buckets > 0, (String)"io.logz.sender.buckets must be positive: %s", buckets);
        LinearCongruentialGenerator generator = new LinearCongruentialGenerator(input);
        int candidate = 0;
        while ((next = (int)((double)(candidate + 1) / generator.nextDouble())) >= 0 && next < buckets) {
            candidate = next;
        }
        return candidate;
    }

    public static HashCode combineOrdered(Iterable<HashCode> hashCodes) {
        Iterator iterator = hashCodes.iterator();
        Preconditions.checkArgument(iterator.hasNext(), (io.logz.sender.java.lang.Object)"io.logz.sender.Must be at least 1 hash code to combine.");
        int bits = ((HashCode)iterator.next()).bits();
        byte[] resultBytes = new byte[bits / 8];
        for (HashCode hashCode : hashCodes) {
            byte[] nextBytes = hashCode.asBytes();
            Preconditions.checkArgument(nextBytes.length == resultBytes.length, (io.logz.sender.java.lang.Object)"io.logz.sender.All hashcodes must have the same bit length.");
            for (int i = 0; i < nextBytes.length; ++i) {
                resultBytes[i] = (byte)(resultBytes[i] * 37 ^ nextBytes[i]);
            }
        }
        return HashCode.fromBytesNoCopy(resultBytes);
    }

    public static HashCode combineUnordered(Iterable<HashCode> hashCodes) {
        Iterator iterator = hashCodes.iterator();
        Preconditions.checkArgument(iterator.hasNext(), (io.logz.sender.java.lang.Object)"io.logz.sender.Must be at least 1 hash code to combine.");
        byte[] resultBytes = new byte[((HashCode)iterator.next()).bits() / 8];
        for (HashCode hashCode : hashCodes) {
            byte[] nextBytes = hashCode.asBytes();
            Preconditions.checkArgument(nextBytes.length == resultBytes.length, (io.logz.sender.java.lang.Object)"io.logz.sender.All hashcodes must have the same bit length.");
            for (int i = 0; i < nextBytes.length; ++i) {
                int n = i;
                resultBytes[n] = (byte)(resultBytes[n] + nextBytes[i]);
            }
        }
        return HashCode.fromBytesNoCopy(resultBytes);
    }

    static int checkPositiveAndMakeMultipleOf32(int bits) {
        Preconditions.checkArgument(bits > 0, (io.logz.sender.java.lang.Object)"io.logz.sender.Number of bits must be positive");
        return bits + 31 & 0xFFFFFFE0;
    }

    public static HashFunction concatenating(HashFunction first, HashFunction second, HashFunction ... rest) {
        ArrayList list = new ArrayList();
        list.add((io.logz.sender.java.lang.Object)first);
        list.add((io.logz.sender.java.lang.Object)second);
        list.addAll((Collection)Arrays.asList((io.logz.sender.java.lang.Object[])rest));
        return new ConcatenatedHashFunction((HashFunction[])list.toArray((io.logz.sender.java.lang.Object[])new HashFunction[0]));
    }

    public static HashFunction concatenating(Iterable<HashFunction> hashFunctions) {
        Preconditions.checkNotNull(hashFunctions);
        ArrayList list = new ArrayList();
        for (HashFunction hashFunction : hashFunctions) {
            list.add((io.logz.sender.java.lang.Object)hashFunction);
        }
        Preconditions.checkArgument(list.size() > 0, (String)"io.logz.sender.number of hash functions (%s) must be > 0", list.size());
        return new ConcatenatedHashFunction((HashFunction[])list.toArray((io.logz.sender.java.lang.Object[])new HashFunction[0]));
    }

    private Hashing() {
    }

    private static final class LinearCongruentialGenerator
    extends io.logz.sender.java.lang.Object {
        private long state;

        public LinearCongruentialGenerator(long seed) {
            this.state = seed;
        }

        public double nextDouble() {
            this.state = 2862933555777941757L * this.state + 1L;
            return (double)((int)(this.state >>> 33) + 1) / 2.147483648E9;
        }
    }

    private static final class ConcatenatedHashFunction
    extends AbstractCompositeHashFunction {
        private ConcatenatedHashFunction(HashFunction ... functions) {
            super(functions);
            for (HashFunction function : functions) {
                Preconditions.checkArgument(function.bits() % 8 == 0, (String)"io.logz.sender.the number of bits (%s) in hashFunction (%s) must be divisible by 8", function.bits(), (io.logz.sender.java.lang.Object)function);
            }
        }

        @Override
        HashCode makeHash(Hasher[] hashers) {
            byte[] bytes = new byte[this.bits() / 8];
            int i = 0;
            for (Hasher hasher : hashers) {
                HashCode newHash = hasher.hash();
                i += newHash.writeBytesTo(bytes, i, newHash.bits() / 8);
            }
            return HashCode.fromBytesNoCopy(bytes);
        }

        @Override
        public int bits() {
            int bitSum = 0;
            for (HashFunction function : this.functions) {
                bitSum += function.bits();
            }
            return bitSum;
        }

        public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
            if (object instanceof ConcatenatedHashFunction) {
                ConcatenatedHashFunction other = (ConcatenatedHashFunction)object;
                return Arrays.equals((io.logz.sender.java.lang.Object[])this.functions, (io.logz.sender.java.lang.Object[])other.functions);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode((io.logz.sender.java.lang.Object[])this.functions);
        }
    }

    @Immutable
    static abstract class ChecksumType
    extends Enum<ChecksumType>
    implements ImmutableSupplier<Checksum> {
        public static final /* enum */ ChecksumType CRC_32 = new ChecksumType((String)"io.logz.sender.Hashing.crc32()"){

            @Override
            public Checksum get() {
                return new CRC32();
            }
        };
        public static final /* enum */ ChecksumType ADLER_32 = new ChecksumType((String)"io.logz.sender.Hashing.adler32()"){

            @Override
            public Checksum get() {
                return new Adler32();
            }
        };
        public final HashFunction hashFunction;
        private static final /* synthetic */ ChecksumType[] $VALUES;

        public static ChecksumType[] values() {
            return (ChecksumType[])$VALUES.clone();
        }

        public static ChecksumType valueOf(String name) {
            return (ChecksumType)Enum.valueOf(ChecksumType.class, (String)name);
        }

        private ChecksumType(String toString) {
            super((String)string, n);
            this.hashFunction = new ChecksumHashFunction(this, 32, toString);
        }

        static {
            $VALUES = new ChecksumType[]{CRC_32, ADLER_32};
        }
    }

    private static class Sha512Holder
    extends io.logz.sender.java.lang.Object {
        static final HashFunction SHA_512 = new MessageDigestHashFunction((String)"io.logz.sender.SHA-512", (String)"io.logz.sender.Hashing.sha512()");

        private Sha512Holder() {
        }
    }

    private static class Sha384Holder
    extends io.logz.sender.java.lang.Object {
        static final HashFunction SHA_384 = new MessageDigestHashFunction((String)"io.logz.sender.SHA-384", (String)"io.logz.sender.Hashing.sha384()");

        private Sha384Holder() {
        }
    }

    private static class Sha256Holder
    extends io.logz.sender.java.lang.Object {
        static final HashFunction SHA_256 = new MessageDigestHashFunction((String)"io.logz.sender.SHA-256", (String)"io.logz.sender.Hashing.sha256()");

        private Sha256Holder() {
        }
    }

    private static class Sha1Holder
    extends io.logz.sender.java.lang.Object {
        static final HashFunction SHA_1 = new MessageDigestHashFunction((String)"io.logz.sender.SHA-1", (String)"io.logz.sender.Hashing.sha1()");

        private Sha1Holder() {
        }
    }

    private static class Md5Holder
    extends io.logz.sender.java.lang.Object {
        static final HashFunction MD5 = new MessageDigestHashFunction((String)"io.logz.sender.MD5", (String)"io.logz.sender.Hashing.md5()");

        private Md5Holder() {
        }
    }
}

