/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.hash;

import io.logz.sender.com.google.common.primitives.Longs;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.Math;
import io.logz.sender.java.lang.NoSuchFieldError;
import io.logz.sender.java.lang.RuntimeException;
import io.logz.sender.java.lang.SecurityException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.System;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.lang.reflect.Field;
import io.logz.sender.java.nio.ByteOrder;
import io.logz.sender.java.security.AccessController;
import io.logz.sender.java.security.PrivilegedActionException;
import io.logz.sender.java.security.PrivilegedExceptionAction;
import io.logz.sender.sun.misc.Unsafe;

final class LittleEndianByteArray
extends io.logz.sender.java.lang.Object {
    private static final LittleEndianBytes byteArray;

    static long load64(byte[] input, int offset) {
        if (!$assertionsDisabled && input.length < offset + 8) {
            throw new AssertionError();
        }
        return byteArray.getLongLittleEndian(input, offset);
    }

    static long load64Safely(byte[] input, int offset, int length) {
        long result = 0L;
        int limit = Math.min((int)length, (int)8);
        for (int i = 0; i < limit; ++i) {
            result |= ((long)input[offset + i] & 0xFFL) << i * 8;
        }
        return result;
    }

    static void store64(byte[] sink, int offset, long value) {
        if (!($assertionsDisabled || offset >= 0 && offset + 8 <= sink.length)) {
            throw new AssertionError();
        }
        byteArray.putLongLittleEndian(sink, offset, value);
    }

    static int load32(byte[] source, int offset) {
        return source[offset] & 0xFF | (source[offset + 1] & 0xFF) << 8 | (source[offset + 2] & 0xFF) << 16 | (source[offset + 3] & 0xFF) << 24;
    }

    static boolean usingUnsafe() {
        return byteArray instanceof UnsafeByteArray;
    }

    private LittleEndianByteArray() {
    }

    static {
        Enum theGetter = JavaLittleEndianBytes.INSTANCE;
        try {
            String arch = System.getProperty((String)"io.logz.sender.os.arch");
            if ("io.logz.sender.amd64".equals((io.logz.sender.java.lang.Object)arch)) {
                theGetter = ByteOrder.nativeOrder().equals((io.logz.sender.java.lang.Object)ByteOrder.LITTLE_ENDIAN) ? UnsafeByteArray.UNSAFE_LITTLE_ENDIAN : UnsafeByteArray.UNSAFE_BIG_ENDIAN;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byteArray = theGetter;
    }

    private static abstract class JavaLittleEndianBytes
    extends Enum<JavaLittleEndianBytes>
    implements LittleEndianBytes {
        public static final /* enum */ JavaLittleEndianBytes INSTANCE = new JavaLittleEndianBytes(){

            @Override
            public long getLongLittleEndian(byte[] source, int offset) {
                return Longs.fromBytes(source[offset + 7], source[offset + 6], source[offset + 5], source[offset + 4], source[offset + 3], source[offset + 2], source[offset + 1], source[offset]);
            }

            @Override
            public void putLongLittleEndian(byte[] sink, int offset, long value) {
                long mask = 255L;
                for (int i = 0; i < 8; ++i) {
                    sink[offset + i] = (byte)((value & mask) >> i * 8);
                    mask <<= 8;
                }
            }
        };
        private static final /* synthetic */ JavaLittleEndianBytes[] $VALUES;

        public static JavaLittleEndianBytes[] values() {
            return (JavaLittleEndianBytes[])$VALUES.clone();
        }

        public static JavaLittleEndianBytes valueOf(String name) {
            return (JavaLittleEndianBytes)Enum.valueOf(JavaLittleEndianBytes.class, (String)name);
        }

        private JavaLittleEndianBytes() {
            super((String)string, n);
        }

        static {
            $VALUES = new JavaLittleEndianBytes[]{INSTANCE};
        }
    }

    private static abstract class UnsafeByteArray
    extends Enum<UnsafeByteArray>
    implements LittleEndianBytes {
        public static final /* enum */ UnsafeByteArray UNSAFE_LITTLE_ENDIAN = new UnsafeByteArray(){

            @Override
            public long getLongLittleEndian(byte[] array, int offset) {
                return theUnsafe.getLong((io.logz.sender.java.lang.Object)array, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET);
            }

            @Override
            public void putLongLittleEndian(byte[] array, int offset, long value) {
                theUnsafe.putLong((io.logz.sender.java.lang.Object)array, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET, value);
            }
        };
        public static final /* enum */ UnsafeByteArray UNSAFE_BIG_ENDIAN = new UnsafeByteArray(){

            @Override
            public long getLongLittleEndian(byte[] array, int offset) {
                long bigEndian = theUnsafe.getLong((io.logz.sender.java.lang.Object)array, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET);
                return Long.reverseBytes((long)bigEndian);
            }

            @Override
            public void putLongLittleEndian(byte[] array, int offset, long value) {
                long littleEndianValue = Long.reverseBytes((long)value);
                theUnsafe.putLong((io.logz.sender.java.lang.Object)array, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET, littleEndianValue);
            }
        };
        private static final Unsafe theUnsafe;
        private static final int BYTE_ARRAY_BASE_OFFSET;
        private static final /* synthetic */ UnsafeByteArray[] $VALUES;

        public static UnsafeByteArray[] values() {
            return (UnsafeByteArray[])$VALUES.clone();
        }

        public static UnsafeByteArray valueOf(String name) {
            return (UnsafeByteArray)Enum.valueOf(UnsafeByteArray.class, (String)name);
        }

        private UnsafeByteArray() {
            super((String)string, n);
        }

        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    return (Unsafe)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction<Unsafe>(){

                        public Unsafe run() throws Exception {
                            Class<Unsafe> k = Unsafe.class;
                            for (Field f : k.getDeclaredFields()) {
                                f.setAccessible(true);
                                io.logz.sender.java.lang.Object x = f.get(null);
                                if (!k.isInstance(x)) continue;
                                return (Unsafe)k.cast(x);
                            }
                            throw new NoSuchFieldError((String)"io.logz.sender.the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException((String)"io.logz.sender.Could not initialize intrinsics", e.getCause());
                }
            }
        }

        static {
            $VALUES = new UnsafeByteArray[]{UNSAFE_LITTLE_ENDIAN, UNSAFE_BIG_ENDIAN};
            theUnsafe = UnsafeByteArray.getUnsafe();
            BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
        }
    }

    private static interface LittleEndianBytes {
        public long getLongLittleEndian(byte[] var1, int var2);

        public void putLongLittleEndian(byte[] var1, int var2, long var3);
    }
}

