/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.math;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.ArithmeticException;
import io.logz.sender.java.lang.IllegalArgumentException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.math.BigInteger;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
@CanIgnoreReturnValue
final class MathPreconditions
extends io.logz.sender.java.lang.Object {
    static int checkPositive(@NullableDecl String role, int x) {
        if (x <= 0) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"io.logz.sender. (").append(x).append((String)"io.logz.sender.) must be > 0").toString());
        }
        return x;
    }

    static long checkPositive(@NullableDecl String role, long x) {
        if (x <= 0L) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"io.logz.sender. (").append(x).append((String)"io.logz.sender.) must be > 0").toString());
        }
        return x;
    }

    static BigInteger checkPositive(@NullableDecl String role, BigInteger x) {
        if (x.signum() <= 0) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"io.logz.sender. (").append((io.logz.sender.java.lang.Object)x).append((String)"io.logz.sender.) must be > 0").toString());
        }
        return x;
    }

    static int checkNonNegative(@NullableDecl String role, int x) {
        if (x < 0) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"io.logz.sender. (").append(x).append((String)"io.logz.sender.) must be >= 0").toString());
        }
        return x;
    }

    static long checkNonNegative(@NullableDecl String role, long x) {
        if (x < 0L) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"io.logz.sender. (").append(x).append((String)"io.logz.sender.) must be >= 0").toString());
        }
        return x;
    }

    static BigInteger checkNonNegative(@NullableDecl String role, BigInteger x) {
        if (x.signum() < 0) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"io.logz.sender. (").append((io.logz.sender.java.lang.Object)x).append((String)"io.logz.sender.) must be >= 0").toString());
        }
        return x;
    }

    static double checkNonNegative(@NullableDecl String role, double x) {
        if (!(x >= 0.0)) {
            throw new IllegalArgumentException(new StringBuilder().append(role).append((String)"io.logz.sender. (").append(x).append((String)"io.logz.sender.) must be >= 0").toString());
        }
        return x;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException((String)"io.logz.sender.mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRange(boolean condition) {
        if (!condition) {
            throw new ArithmeticException((String)"io.logz.sender.not in range");
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, int a, int b) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder().append((String)"io.logz.sender.overflow: ").append(methodName).append((String)"io.logz.sender.(").append(a).append((String)"io.logz.sender., ").append(b).append((String)"io.logz.sender.)").toString());
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, long a, long b) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder().append((String)"io.logz.sender.overflow: ").append(methodName).append((String)"io.logz.sender.(").append(a).append((String)"io.logz.sender., ").append(b).append((String)"io.logz.sender.)").toString());
        }
    }

    private MathPreconditions() {
    }
}

