/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.primitives;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.annotations.VisibleForTesting;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.primitives.UnsignedLongs;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.Error;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.Math;
import io.logz.sender.java.lang.NoSuchFieldError;
import io.logz.sender.java.lang.NumberFormatException;
import io.logz.sender.java.lang.RuntimeException;
import io.logz.sender.java.lang.SecurityException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.System;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.lang.reflect.Field;
import io.logz.sender.java.nio.ByteOrder;
import io.logz.sender.java.security.AccessController;
import io.logz.sender.java.security.PrivilegedActionException;
import io.logz.sender.java.security.PrivilegedExceptionAction;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.java.util.Comparator;
import io.logz.sender.sun.misc.Unsafe;

@GwtIncompatible
public final class UnsignedBytes
extends io.logz.sender.java.lang.Object {
    public static final byte MAX_POWER_OF_TWO = -128;
    public static final byte MAX_VALUE = -1;
    private static final int UNSIGNED_MASK = 255;

    private UnsignedBytes() {
    }

    public static int toInt(byte value) {
        return value & 0xFF;
    }

    @CanIgnoreReturnValue
    public static byte checkedCast(long value) {
        Preconditions.checkArgument(value >> 8 == 0L, (String)"io.logz.sender.out of range: %s", value);
        return (byte)value;
    }

    public static byte saturatedCast(long value) {
        if (value > (long)UnsignedBytes.toInt((byte)-1)) {
            return -1;
        }
        if (value < 0L) {
            return 0;
        }
        return (byte)value;
    }

    public static int compare(byte a, byte b) {
        return UnsignedBytes.toInt(a) - UnsignedBytes.toInt(b);
    }

    public static byte min(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int min = UnsignedBytes.toInt(array[0]);
        for (int i = 1; i < array.length; ++i) {
            int next = UnsignedBytes.toInt(array[i]);
            if (next >= min) continue;
            min = next;
        }
        return (byte)min;
    }

    public static byte max(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int max = UnsignedBytes.toInt(array[0]);
        for (int i = 1; i < array.length; ++i) {
            int next = UnsignedBytes.toInt(array[i]);
            if (next <= max) continue;
            max = next;
        }
        return (byte)max;
    }

    @Beta
    public static String toString(byte x) {
        return UnsignedBytes.toString(x, 10);
    }

    @Beta
    public static String toString(byte x, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, (String)"io.logz.sender.radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        return Integer.toString((int)UnsignedBytes.toInt(x), (int)radix);
    }

    @Beta
    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string) {
        return UnsignedBytes.parseUnsignedByte(string, 10);
    }

    @Beta
    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string, int radix) {
        int parse = Integer.parseInt((String)Preconditions.checkNotNull(string), (int)radix);
        if (parse >> 8 == 0) {
            return (byte)parse;
        }
        throw new NumberFormatException(new StringBuilder().append((String)"io.logz.sender.out of range: ").append(parse).toString());
    }

    public static String join(String separator, byte ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "io.logz.sender.";
        }
        StringBuilder builder = new StringBuilder(array.length * (3 + separator.length()));
        builder.append(UnsignedBytes.toInt(array[0]));
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(UnsignedBytes.toString(array[i]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    private static byte flip(byte b) {
        return (byte)(b ^ 0x80);
    }

    public static void sort(byte[] array) {
        Preconditions.checkNotNull(array);
        UnsignedBytes.sort(array, 0, array.length);
    }

    public static void sort(byte[] array, int fromIndex, int toIndex) {
        int i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (i = fromIndex; i < toIndex; ++i) {
            array[i] = UnsignedBytes.flip(array[i]);
        }
        Arrays.sort((byte[])array, (int)fromIndex, (int)toIndex);
        for (i = fromIndex; i < toIndex; ++i) {
            array[i] = UnsignedBytes.flip(array[i]);
        }
    }

    public static void sortDescending(byte[] array) {
        Preconditions.checkNotNull(array);
        UnsignedBytes.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(byte[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array[n] = (byte)(array[n] ^ 0x7F);
        }
        Arrays.sort((byte[])array, (int)fromIndex, (int)toIndex);
        i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array[n] = (byte)(array[n] ^ 0x7F);
        }
    }

    @VisibleForTesting
    static class LexicographicalComparatorHolder
    extends io.logz.sender.java.lang.Object {
        static final String UNSAFE_COMPARATOR_NAME = new StringBuilder().append(LexicographicalComparatorHolder.class.getName()).append((String)"io.logz.sender.$UnsafeComparator").toString();
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        LexicographicalComparatorHolder() {
        }

        static Comparator<byte[]> getBestComparator() {
            try {
                io.logz.sender.java.lang.Class theClass = io.logz.sender.java.lang.Class.forName((String)UNSAFE_COMPARATOR_NAME);
                Comparator comparator = (Comparator)theClass.getEnumConstants()[0];
                return comparator;
            }
            catch (Throwable t) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        static final class PureJavaComparator
        extends Enum<PureJavaComparator>
        implements Comparator<byte[]> {
            public static final /* enum */ PureJavaComparator INSTANCE = new PureJavaComparator((String)"io.logz.sender.INSTANCE", 0);
            private static final /* synthetic */ PureJavaComparator[] $VALUES;

            public static PureJavaComparator[] values() {
                return (PureJavaComparator[])$VALUES.clone();
            }

            public static PureJavaComparator valueOf(String name) {
                return (PureJavaComparator)Enum.valueOf(PureJavaComparator.class, (String)name);
            }

            private PureJavaComparator() {
                super((String)string, n);
            }

            public int compare(byte[] left, byte[] right) {
                int minLength = Math.min((int)left.length, (int)right.length);
                for (int i = 0; i < minLength; ++i) {
                    int result = UnsignedBytes.compare(left[i], right[i]);
                    if (result == 0) continue;
                    return result;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "io.logz.sender.UnsignedBytes.lexicographicalComparator() (pure Java version)";
            }

            static {
                $VALUES = new PureJavaComparator[]{INSTANCE};
            }
        }

        @VisibleForTesting
        static final class UnsafeComparator
        extends Enum<UnsafeComparator>
        implements Comparator<byte[]> {
            public static final /* enum */ UnsafeComparator INSTANCE = new UnsafeComparator((String)"io.logz.sender.INSTANCE", 0);
            static final boolean BIG_ENDIAN;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;
            private static final /* synthetic */ UnsafeComparator[] $VALUES;

            public static UnsafeComparator[] values() {
                return (UnsafeComparator[])$VALUES.clone();
            }

            public static UnsafeComparator valueOf(String name) {
                return (UnsafeComparator)Enum.valueOf(UnsafeComparator.class, (String)name);
            }

            private UnsafeComparator() {
                super((String)string, n);
            }

            private static Unsafe getUnsafe() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (SecurityException securityException) {
                    try {
                        return (Unsafe)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction<Unsafe>(){

                            public Unsafe run() throws Exception {
                                Class<Unsafe> k = Unsafe.class;
                                for (Field f : k.getDeclaredFields()) {
                                    f.setAccessible(true);
                                    io.logz.sender.java.lang.Object x = f.get(null);
                                    if (!k.isInstance(x)) continue;
                                    return (Unsafe)k.cast(x);
                                }
                                throw new NoSuchFieldError((String)"io.logz.sender.the Unsafe");
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw new RuntimeException((String)"io.logz.sender.Could not initialize intrinsics", e.getCause());
                    }
                }
            }

            public int compare(byte[] left, byte[] right) {
                int i;
                int stride = 8;
                int minLength = Math.min((int)left.length, (int)right.length);
                int strideLimit = minLength & 0xFFFFFFF8;
                for (i = 0; i < strideLimit; i += 8) {
                    long rw;
                    long lw = theUnsafe.getLong((io.logz.sender.java.lang.Object)left, (long)BYTE_ARRAY_BASE_OFFSET + (long)i);
                    if (lw == (rw = theUnsafe.getLong((io.logz.sender.java.lang.Object)right, (long)BYTE_ARRAY_BASE_OFFSET + (long)i))) continue;
                    if (BIG_ENDIAN) {
                        return UnsignedLongs.compare(lw, rw);
                    }
                    int n = Long.numberOfTrailingZeros((long)(lw ^ rw)) & 0xFFFFFFF8;
                    return (int)(lw >>> n & 0xFFL) - (int)(rw >>> n & 0xFFL);
                }
                while (i < minLength) {
                    int result = UnsignedBytes.compare(left[i], right[i]);
                    if (result != 0) {
                        return result;
                    }
                    ++i;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "io.logz.sender.UnsignedBytes.lexicographicalComparator() (sun.misc.Unsafe version)";
            }

            static {
                $VALUES = new UnsafeComparator[]{INSTANCE};
                BIG_ENDIAN = ByteOrder.nativeOrder().equals((io.logz.sender.java.lang.Object)ByteOrder.BIG_ENDIAN);
                theUnsafe = UnsafeComparator.getUnsafe();
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (!"io.logz.sender.64".equals((io.logz.sender.java.lang.Object)System.getProperty((String)"io.logz.sender.sun.arch.data.model")) || BYTE_ARRAY_BASE_OFFSET % 8 != 0 || theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new Error();
                }
            }
        }
    }
}

