/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.collect.Sets;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.util.Set;
import io.logz.sender.java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import io.logz.sender.java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import io.logz.sender.java.util.logging.Level;
import io.logz.sender.java.util.logging.Logger;

@GwtCompatible(emulated=true)
abstract class AggregateFutureState
extends io.logz.sender.java.lang.Object {
    private volatile Set<Throwable> seenExceptions = null;
    private volatile int remaining;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Logger log;

    AggregateFutureState(int remainingFutures) {
        this.remaining = remainingFutures;
    }

    final Set<Throwable> getOrInitSeenExceptions() {
        Object seenExceptionsLocal = this.seenExceptions;
        if (seenExceptionsLocal == null) {
            seenExceptionsLocal = Sets.newConcurrentHashSet();
            this.addInitialException((Set<Throwable>)seenExceptionsLocal);
            ATOMIC_HELPER.compareAndSetSeenExceptions(this, null, (Set<Throwable>)seenExceptionsLocal);
            seenExceptionsLocal = this.seenExceptions;
        }
        return seenExceptionsLocal;
    }

    abstract void addInitialException(Set<Throwable> var1);

    final int decrementRemainingAndGet() {
        return ATOMIC_HELPER.decrementAndGetRemainingCount(this);
    }

    static {
        AtomicHelper helper;
        log = Logger.getLogger((String)AggregateFutureState.class.getName());
        Throwable thrownReflectionFailure = null;
        try {
            helper = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(AggregateFutureState.class, Set.class, (String)"io.logz.sender.seenExceptions"), AtomicIntegerFieldUpdater.newUpdater(AggregateFutureState.class, (String)"io.logz.sender.remaining"));
        }
        catch (Throwable reflectionFailure) {
            thrownReflectionFailure = reflectionFailure;
            helper = new SynchronizedAtomicHelper();
        }
        ATOMIC_HELPER = helper;
        if (thrownReflectionFailure != null) {
            log.log(Level.SEVERE, (String)"io.logz.sender.SafeAtomicHelper is broken!", thrownReflectionFailure);
        }
    }

    private static final class SynchronizedAtomicHelper
    extends AtomicHelper {
        private SynchronizedAtomicHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void compareAndSetSeenExceptions(AggregateFutureState state, Set<Throwable> expect, Set<Throwable> update) {
            AggregateFutureState aggregateFutureState = state;
            synchronized (aggregateFutureState) {
                if (state.seenExceptions == expect) {
                    state.seenExceptions = update;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int decrementAndGetRemainingCount(AggregateFutureState state) {
            AggregateFutureState aggregateFutureState = state;
            synchronized (aggregateFutureState) {
                state.remaining--;
                return state.remaining;
            }
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<AggregateFutureState, Set<Throwable>> seenExceptionsUpdater;
        final AtomicIntegerFieldUpdater<AggregateFutureState> remainingCountUpdater;

        SafeAtomicHelper(AtomicReferenceFieldUpdater seenExceptionsUpdater, AtomicIntegerFieldUpdater remainingCountUpdater) {
            this.seenExceptionsUpdater = seenExceptionsUpdater;
            this.remainingCountUpdater = remainingCountUpdater;
        }

        @Override
        void compareAndSetSeenExceptions(AggregateFutureState state, Set<Throwable> expect, Set<Throwable> update) {
            this.seenExceptionsUpdater.compareAndSet((io.logz.sender.java.lang.Object)state, expect, update);
        }

        @Override
        int decrementAndGetRemainingCount(AggregateFutureState state) {
            return this.remainingCountUpdater.decrementAndGet((io.logz.sender.java.lang.Object)state);
        }
    }

    private static abstract class AtomicHelper
    extends io.logz.sender.java.lang.Object {
        private AtomicHelper() {
        }

        abstract void compareAndSetSeenExceptions(AggregateFutureState var1, Set<Throwable> var2, Set<Throwable> var3);

        abstract int decrementAndGetRemainingCount(AggregateFutureState var1);
    }
}

