/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Optional;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.ImmutableCollection;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.common.collect.Lists;
import io.logz.sender.com.google.common.util.concurrent.AggregateFuture;
import io.logz.sender.com.google.common.util.concurrent.ListenableFuture;
import io.logz.sender.java.util.ArrayList;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.List;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
abstract class CollectionFuture<V extends io.logz.sender.java.lang.Object, C extends io.logz.sender.java.lang.Object>
extends AggregateFuture<V, C> {
    CollectionFuture() {
    }

    static final class ListFuture<V extends io.logz.sender.java.lang.Object>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            this.init(new ListFutureRunningState(futures, allMustSucceed));
        }

        private final class ListFutureRunningState
        extends CollectionFutureRunningState {
            ListFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
                super(futures, allMustSucceed);
            }

            public List<V> combine(List<Optional<V>> values) {
                ArrayList result = Lists.newArrayListWithCapacity(values.size());
                for (Optional element : values) {
                    result.add(element != null ? (io.logz.sender.java.lang.Object)element.orNull() : null);
                }
                return Collections.unmodifiableList(result);
            }
        }
    }

    abstract class CollectionFutureRunningState
    extends AggregateFuture.RunningState {
        private List<Optional<V>> values;

        CollectionFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed, true);
            this.values = futures.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity(futures.size());
            for (int i = 0; i < futures.size(); ++i) {
                this.values.add(null);
            }
        }

        final void collectOneValue(boolean allMustSucceed, int index, @NullableDecl V returnValue) {
            List localValues = this.values;
            if (localValues != null) {
                localValues.set(index, Optional.fromNullable(returnValue));
            } else {
                Preconditions.checkState(allMustSucceed || CollectionFuture.this.isCancelled(), (io.logz.sender.java.lang.Object)"io.logz.sender.Future was done before all dependencies completed");
            }
        }

        @Override
        final void handleAllCompleted() {
            List localValues = this.values;
            if (localValues != null) {
                CollectionFuture.this.set(this.combine(localValues));
            } else {
                Preconditions.checkState(CollectionFuture.this.isDone());
            }
        }

        @Override
        void releaseResourcesAfterFailure() {
            super.releaseResourcesAfterFailure();
            this.values = null;
        }

        abstract C combine(List<Optional<V>> var1);
    }
}

