/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.ForwardingObject;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.InterruptedException;
import io.logz.sender.java.util.concurrent.ExecutionException;
import io.logz.sender.java.util.concurrent.Future;
import io.logz.sender.java.util.concurrent.TimeUnit;
import io.logz.sender.java.util.concurrent.TimeoutException;

@CanIgnoreReturnValue
@GwtCompatible
public abstract class ForwardingFuture<V extends io.logz.sender.java.lang.Object>
extends ForwardingObject
implements Future<V> {
    protected ForwardingFuture() {
    }

    protected abstract Future<? extends V> delegate();

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate().cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate().isCancelled();
    }

    public boolean isDone() {
        return this.delegate().isDone();
    }

    public V get() throws InterruptedException, ExecutionException {
        return (V)this.delegate().get();
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.delegate().get(timeout, unit);
    }

    public static abstract class SimpleForwardingFuture<V extends io.logz.sender.java.lang.Object>
    extends ForwardingFuture<V> {
        private final Future<V> delegate;

        protected SimpleForwardingFuture(Future<V> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected final Future<V> delegate() {
            return this.delegate;
        }
    }
}

