/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.Runnable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Thread;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.util.concurrent.atomic.AtomicReference;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
abstract class InterruptibleTask<T extends io.logz.sender.java.lang.Object>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE = new DoNothingRunnable();
    private static final Runnable INTERRUPTING = new DoNothingRunnable();

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Thread currentThread = Thread.currentThread();
        if (!this.compareAndSet(null, (io.logz.sender.java.lang.Object)currentThread)) {
            return;
        }
        boolean run = !this.isDone();
        T result = null;
        Throwable error = null;
        try {
            if (run) {
                result = this.runInterruptibly();
            }
        }
        catch (Throwable t) {
            error = t;
        }
        finally {
            if (!this.compareAndSet((io.logz.sender.java.lang.Object)currentThread, (io.logz.sender.java.lang.Object)DONE)) {
                while (this.get() == INTERRUPTING) {
                    Thread.yield();
                }
            }
            if (run) {
                this.afterRanInterruptibly(result, error);
            }
        }
    }

    abstract boolean isDone();

    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptibly(@NullableDecl T var1, @NullableDecl Throwable var2);

    final void interruptTask() {
        Runnable currentRunner = (Runnable)this.get();
        if (currentRunner instanceof Thread && this.compareAndSet((io.logz.sender.java.lang.Object)currentRunner, (io.logz.sender.java.lang.Object)INTERRUPTING)) {
            ((Thread)currentRunner).interrupt();
            this.set((io.logz.sender.java.lang.Object)DONE);
        }
    }

    public final String toString() {
        Runnable state = (Runnable)this.get();
        Object result = state == DONE ? "io.logz.sender.running=[DONE]" : (state == INTERRUPTING ? "io.logz.sender.running=[INTERRUPTED]" : (state instanceof Thread ? new StringBuilder().append((String)"io.logz.sender.running=[RUNNING ON ").append(((Thread)state).getName()).append((String)"io.logz.sender.]").toString() : "io.logz.sender.running=[NOT STARTED YET]"));
        return new StringBuilder().append((String)result).append((String)"io.logz.sender., ").append(this.toPendingString()).toString();
    }

    abstract String toPendingString();

    private static final class DoNothingRunnable
    extends io.logz.sender.java.lang.Object
    implements Runnable {
        private DoNothingRunnable() {
        }

        public void run() {
        }
    }
}

