/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.util.concurrent.AbstractFuture;
import io.logz.sender.com.google.common.util.concurrent.ListenableFuture;
import io.logz.sender.com.google.common.util.concurrent.MoreExecutors;
import io.logz.sender.java.lang.Runnable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.util.concurrent.Future;
import io.logz.sender.java.util.concurrent.ScheduledExecutorService;
import io.logz.sender.java.util.concurrent.TimeUnit;
import io.logz.sender.java.util.concurrent.TimeoutException;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtIncompatible
final class TimeoutFuture<V extends io.logz.sender.java.lang.Object>
extends AbstractFuture.TrustedFuture<V> {
    @NullableDecl
    private ListenableFuture<V> delegateRef;
    @NullableDecl
    private Future<?> timer;

    static <V extends io.logz.sender.java.lang.Object> ListenableFuture<V> create(ListenableFuture<V> delegate, long time, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        TimeoutFuture<V> result = new TimeoutFuture<V>(delegate);
        Fire<V> fire = new Fire<V>(result);
        result.timer = scheduledExecutor.schedule(fire, time, unit);
        delegate.addListener(fire, MoreExecutors.directExecutor());
        return result;
    }

    private TimeoutFuture(ListenableFuture<V> delegate) {
        this.delegateRef = Preconditions.checkNotNull(delegate);
    }

    @Override
    protected String pendingToString() {
        ListenableFuture<V> localInputFuture = this.delegateRef;
        if (localInputFuture != null) {
            return new StringBuilder().append((String)"io.logz.sender.inputFuture=[").append(localInputFuture).append((String)"io.logz.sender.]").toString();
        }
        return null;
    }

    @Override
    protected void afterDone() {
        this.maybePropagateCancellationTo(this.delegateRef);
        Future<?> localTimer = this.timer;
        if (localTimer != null) {
            localTimer.cancel(false);
        }
        this.delegateRef = null;
        this.timer = null;
    }

    private static final class Fire<V extends io.logz.sender.java.lang.Object>
    extends io.logz.sender.java.lang.Object
    implements Runnable {
        @NullableDecl
        TimeoutFuture<V> timeoutFutureRef;

        Fire(TimeoutFuture<V> timeoutFuture) {
            this.timeoutFutureRef = timeoutFuture;
        }

        public void run() {
            TimeoutFuture<V> timeoutFuture = this.timeoutFutureRef;
            if (timeoutFuture == null) {
                return;
            }
            ListenableFuture delegate = ((TimeoutFuture)timeoutFuture).delegateRef;
            if (delegate == null) {
                return;
            }
            this.timeoutFutureRef = null;
            if (delegate.isDone()) {
                timeoutFuture.setFuture(delegate);
            } else {
                try {
                    timeoutFuture.setException((Throwable)((Object)new TimeoutException(new StringBuilder().append((String)"io.logz.sender.Future timed out: ").append((io.logz.sender.java.lang.Object)delegate).toString())));
                }
                finally {
                    delegate.cancel(true);
                }
            }
        }
    }
}

