/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson;

import io.logz.sender.com.google.gson.FieldNamingStrategy;
import io.logz.sender.java.lang.Character;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldNamingPolicy
extends Enum<FieldNamingPolicy>
implements FieldNamingStrategy {
    public static final /* enum */ FieldNamingPolicy IDENTITY = new FieldNamingPolicy(){

        public String translateName(Field f) {
            return f.getName();
        }
    };
    public static final /* enum */ FieldNamingPolicy UPPER_CAMEL_CASE = new FieldNamingPolicy(){

        public String translateName(Field f) {
            return FieldNamingPolicy.upperCaseFirstLetter(f.getName());
        }
    };
    public static final /* enum */ FieldNamingPolicy UPPER_CAMEL_CASE_WITH_SPACES = new FieldNamingPolicy(){

        public String translateName(Field f) {
            return FieldNamingPolicy.upperCaseFirstLetter(FieldNamingPolicy.separateCamelCase(f.getName(), (String)"io.logz.sender. "));
        }
    };
    public static final /* enum */ FieldNamingPolicy LOWER_CASE_WITH_UNDERSCORES = new FieldNamingPolicy(){

        public String translateName(Field f) {
            return FieldNamingPolicy.separateCamelCase(f.getName(), (String)"io.logz.sender._").toLowerCase();
        }
    };
    public static final /* enum */ FieldNamingPolicy LOWER_CASE_WITH_DASHES = new FieldNamingPolicy(){

        public String translateName(Field f) {
            return FieldNamingPolicy.separateCamelCase(f.getName(), (String)"io.logz.sender.-").toLowerCase();
        }
    };
    private static final /* synthetic */ FieldNamingPolicy[] $VALUES;

    public static FieldNamingPolicy[] values() {
        return (FieldNamingPolicy[])$VALUES.clone();
    }

    public static FieldNamingPolicy valueOf(String name) {
        return (FieldNamingPolicy)Enum.valueOf(FieldNamingPolicy.class, (String)name);
    }

    private FieldNamingPolicy() {
        super((String)string, n);
    }

    private static String separateCamelCase(String name, String separator) {
        StringBuilder translation = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char character = name.charAt(i);
            if (Character.isUpperCase((char)character) && translation.length() != 0) {
                translation.append(separator);
            }
            translation.append(character);
        }
        return translation.toString();
    }

    private static String upperCaseFirstLetter(String name) {
        StringBuilder fieldNameBuilder = new StringBuilder();
        int index = 0;
        char firstCharacter = name.charAt(index);
        while (index < name.length() - 1 && !Character.isLetter((char)firstCharacter)) {
            fieldNameBuilder.append(firstCharacter);
            firstCharacter = name.charAt(++index);
        }
        if (index == name.length()) {
            return fieldNameBuilder.toString();
        }
        if (!Character.isUpperCase((char)firstCharacter)) {
            String modifiedTarget = FieldNamingPolicy.modifyString(Character.toUpperCase((char)firstCharacter), name, ++index);
            return fieldNameBuilder.append(modifiedTarget).toString();
        }
        return name;
    }

    private static String modifyString(char firstCharacter, String srcString, int indexOfSubstring) {
        return indexOfSubstring < srcString.length() ? new StringBuilder().append(firstCharacter).append(srcString.substring(indexOfSubstring)).toString() : String.valueOf((char)firstCharacter);
    }

    static {
        $VALUES = new FieldNamingPolicy[]{IDENTITY, UPPER_CAMEL_CASE, UPPER_CAMEL_CASE_WITH_SPACES, LOWER_CASE_WITH_UNDERSCORES, LOWER_CASE_WITH_DASHES};
    }
}

