/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson;

import io.logz.sender.com.google.gson.JsonArray;
import io.logz.sender.com.google.gson.JsonElement;
import io.logz.sender.com.google.gson.JsonNull;
import io.logz.sender.com.google.gson.JsonPrimitive;
import io.logz.sender.com.google.gson.internal.LinkedTreeMap;
import io.logz.sender.java.lang.Boolean;
import io.logz.sender.java.lang.Character;
import io.logz.sender.java.lang.Number;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonObject
extends JsonElement {
    private final LinkedTreeMap<String, JsonElement> members = new LinkedTreeMap();

    @Override
    JsonObject deepCopy() {
        JsonObject result = new JsonObject();
        for (Map.Entry entry : this.members.entrySet()) {
            result.add((String)entry.getKey(), ((JsonElement)entry.getValue()).deepCopy());
        }
        return result;
    }

    public void add(String property, JsonElement value) {
        if (value == null) {
            value = JsonNull.INSTANCE;
        }
        this.members.put(property, value);
    }

    public JsonElement remove(String property) {
        return this.members.remove((io.logz.sender.java.lang.Object)property);
    }

    public void addProperty(String property, String value) {
        this.add(property, this.createJsonElement((io.logz.sender.java.lang.Object)value));
    }

    public void addProperty(String property, Number value) {
        this.add(property, this.createJsonElement((io.logz.sender.java.lang.Object)value));
    }

    public void addProperty(String property, Boolean value) {
        this.add(property, this.createJsonElement((io.logz.sender.java.lang.Object)value));
    }

    public void addProperty(String property, Character value) {
        this.add(property, this.createJsonElement((io.logz.sender.java.lang.Object)value));
    }

    private JsonElement createJsonElement(io.logz.sender.java.lang.Object value) {
        return value == null ? JsonNull.INSTANCE : new JsonPrimitive(value);
    }

    public Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.members.entrySet();
    }

    public boolean has(String memberName) {
        return this.members.containsKey((io.logz.sender.java.lang.Object)memberName);
    }

    public JsonElement get(String memberName) {
        return this.members.get((io.logz.sender.java.lang.Object)memberName);
    }

    public JsonPrimitive getAsJsonPrimitive(String memberName) {
        return (JsonPrimitive)this.members.get((io.logz.sender.java.lang.Object)memberName);
    }

    public JsonArray getAsJsonArray(String memberName) {
        return (JsonArray)this.members.get((io.logz.sender.java.lang.Object)memberName);
    }

    public JsonObject getAsJsonObject(String memberName) {
        return (JsonObject)this.members.get((io.logz.sender.java.lang.Object)memberName);
    }

    public boolean equals(io.logz.sender.java.lang.Object o) {
        return o == this || o instanceof JsonObject && ((JsonObject)o).members.equals((io.logz.sender.java.lang.Object)this.members);
    }

    public int hashCode() {
        return this.members.hashCode();
    }
}

