/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.internal;

import io.logz.sender.java.io.ObjectStreamException;
import io.logz.sender.java.lang.Double;
import io.logz.sender.java.lang.Float;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.Number;
import io.logz.sender.java.lang.NumberFormatException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.math.BigDecimal;

public final class LazilyParsedNumber
extends Number {
    private final String value;

    public LazilyParsedNumber(String value) {
        this.value = value;
    }

    public int intValue() {
        try {
            return Integer.parseInt((String)this.value);
        }
        catch (NumberFormatException e) {
            try {
                return (int)Long.parseLong((String)this.value);
            }
            catch (NumberFormatException nfe) {
                return new BigDecimal(this.value).intValue();
            }
        }
    }

    public long longValue() {
        try {
            return Long.parseLong((String)this.value);
        }
        catch (NumberFormatException e) {
            return new BigDecimal(this.value).longValue();
        }
    }

    public float floatValue() {
        return Float.parseFloat((String)this.value);
    }

    public double doubleValue() {
        return Double.parseDouble((String)this.value);
    }

    public String toString() {
        return this.value;
    }

    private io.logz.sender.java.lang.Object writeReplace() throws ObjectStreamException {
        return new BigDecimal(this.value);
    }
}

