/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.internal;

import io.logz.sender.com.google.gson.internal.$Gson$Preconditions;
import io.logz.sender.java.lang.Boolean;
import io.logz.sender.java.lang.Byte;
import io.logz.sender.java.lang.Character;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.Double;
import io.logz.sender.java.lang.Float;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.Short;
import io.logz.sender.java.lang.Void;
import io.logz.sender.java.lang.reflect.Type;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.HashMap;
import io.logz.sender.java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Primitives
extends io.logz.sender.java.lang.Object {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPE;

    private Primitives() {
    }

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static boolean isPrimitive(Type type) {
        return PRIMITIVE_TO_WRAPPER_TYPE.containsKey((io.logz.sender.java.lang.Object)type);
    }

    public static boolean isWrapperType(Type type) {
        return WRAPPER_TO_PRIMITIVE_TYPE.containsKey((io.logz.sender.java.lang.Object)$Gson$Preconditions.checkNotNull(type));
    }

    public static <T extends io.logz.sender.java.lang.Object> Class<T> wrap(Class<T> type) {
        Class wrapped = (Class)PRIMITIVE_TO_WRAPPER_TYPE.get($Gson$Preconditions.checkNotNull(type));
        return wrapped == null ? type : wrapped;
    }

    public static <T extends io.logz.sender.java.lang.Object> Class<T> unwrap(Class<T> type) {
        Class unwrapped = (Class)WRAPPER_TO_PRIMITIVE_TYPE.get($Gson$Preconditions.checkNotNull(type));
        return unwrapped == null ? type : unwrapped;
    }

    static {
        HashMap primToWrap = new HashMap(16);
        HashMap wrapToPrim = new HashMap(16);
        Primitives.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        Primitives.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        Primitives.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        Primitives.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        Primitives.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        Primitives.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        Primitives.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        Primitives.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        Primitives.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap((Map)primToWrap);
        WRAPPER_TO_PRIMITIVE_TYPE = Collections.unmodifiableMap((Map)wrapToPrim);
    }
}

