/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.internal.bind;

import io.logz.sender.com.google.gson.Gson;
import io.logz.sender.com.google.gson.TypeAdapter;
import io.logz.sender.com.google.gson.TypeAdapterFactory;
import io.logz.sender.com.google.gson.internal.LinkedTreeMap;
import io.logz.sender.com.google.gson.reflect.TypeToken;
import io.logz.sender.com.google.gson.stream.JsonReader;
import io.logz.sender.com.google.gson.stream.JsonToken;
import io.logz.sender.com.google.gson.stream.JsonWriter;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.lang.Boolean;
import io.logz.sender.java.lang.Double;
import io.logz.sender.java.lang.IllegalStateException;
import io.logz.sender.java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectTypeAdapter
extends TypeAdapter<io.logz.sender.java.lang.Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T extends io.logz.sender.java.lang.Object> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() == io.logz.sender.java.lang.Object.class) {
                return new ObjectTypeAdapter(gson);
            }
            return null;
        }
    };
    private final Gson gson;

    private ObjectTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public io.logz.sender.java.lang.Object read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                ArrayList list = new ArrayList();
                in.beginArray();
                while (in.hasNext()) {
                    list.add(this.read(in));
                }
                in.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedTreeMap map = new LinkedTreeMap();
                in.beginObject();
                while (in.hasNext()) {
                    map.put((io.logz.sender.java.lang.Object)in.nextName(), this.read(in));
                }
                in.endObject();
                return map;
            }
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                return Double.valueOf((double)in.nextDouble());
            }
            case BOOLEAN: {
                return Boolean.valueOf((boolean)in.nextBoolean());
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void write(JsonWriter out, io.logz.sender.java.lang.Object value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        TypeAdapter<io.logz.sender.java.lang.Object> typeAdapter = this.gson.getAdapter(value.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            out.beginObject();
            out.endObject();
            return;
        }
        typeAdapter.write(out, value);
    }
}

