/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.internal.bind;

import io.logz.sender.com.google.gson.Gson;
import io.logz.sender.com.google.gson.TypeAdapter;
import io.logz.sender.com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import io.logz.sender.com.google.gson.reflect.TypeToken;
import io.logz.sender.com.google.gson.stream.JsonReader;
import io.logz.sender.com.google.gson.stream.JsonWriter;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.reflect.Type;
import io.logz.sender.java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeAdapterRuntimeTypeWrapper<T extends io.logz.sender.java.lang.Object>
extends TypeAdapter<T> {
    private final Gson context;
    private final TypeAdapter<T> delegate;
    private final Type type;

    TypeAdapterRuntimeTypeWrapper(Gson context, TypeAdapter<T> delegate, Type type) {
        this.context = context;
        this.delegate = delegate;
        this.type = type;
    }

    @Override
    public T read(JsonReader in) throws IOException {
        return this.delegate.read(in);
    }

    @Override
    public void write(JsonWriter out, T value) throws IOException {
        TypeAdapter<Object> chosen = this.delegate;
        Type runtimeType = this.getRuntimeTypeIfMoreSpecific(this.type, (io.logz.sender.java.lang.Object)value);
        if (runtimeType != this.type) {
            TypeAdapter<?> runtimeTypeAdapter = this.context.getAdapter(TypeToken.get(runtimeType));
            chosen = !(runtimeTypeAdapter instanceof ReflectiveTypeAdapterFactory.Adapter) ? runtimeTypeAdapter : (!(this.delegate instanceof ReflectiveTypeAdapterFactory.Adapter) ? this.delegate : runtimeTypeAdapter);
        }
        chosen.write(out, value);
    }

    private Type getRuntimeTypeIfMoreSpecific(Type type, io.logz.sender.java.lang.Object value) {
        if (value != null && (type == io.logz.sender.java.lang.Object.class || type instanceof TypeVariable || type instanceof Class)) {
            type = value.getClass();
        }
        return type;
    }
}

