/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.internal.bind;

import io.logz.sender.com.google.gson.Gson;
import io.logz.sender.com.google.gson.JsonArray;
import io.logz.sender.com.google.gson.JsonElement;
import io.logz.sender.com.google.gson.JsonIOException;
import io.logz.sender.com.google.gson.JsonNull;
import io.logz.sender.com.google.gson.JsonObject;
import io.logz.sender.com.google.gson.JsonPrimitive;
import io.logz.sender.com.google.gson.JsonSyntaxException;
import io.logz.sender.com.google.gson.TypeAdapter;
import io.logz.sender.com.google.gson.TypeAdapterFactory;
import io.logz.sender.com.google.gson.annotations.SerializedName;
import io.logz.sender.com.google.gson.internal.LazilyParsedNumber;
import io.logz.sender.com.google.gson.reflect.TypeToken;
import io.logz.sender.com.google.gson.stream.JsonReader;
import io.logz.sender.com.google.gson.stream.JsonToken;
import io.logz.sender.com.google.gson.stream.JsonWriter;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Boolean;
import io.logz.sender.java.lang.Byte;
import io.logz.sender.java.lang.Character;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.Double;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.Float;
import io.logz.sender.java.lang.IllegalArgumentException;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.NoSuchFieldException;
import io.logz.sender.java.lang.Number;
import io.logz.sender.java.lang.NumberFormatException;
import io.logz.sender.java.lang.Object;
import io.logz.sender.java.lang.Short;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuffer;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.lang.UnsupportedOperationException;
import io.logz.sender.java.math.BigDecimal;
import io.logz.sender.java.math.BigInteger;
import io.logz.sender.java.net.InetAddress;
import io.logz.sender.java.net.URI;
import io.logz.sender.java.net.URISyntaxException;
import io.logz.sender.java.net.URL;
import io.logz.sender.java.sql.Timestamp;
import io.logz.sender.java.util.BitSet;
import io.logz.sender.java.util.Calendar;
import io.logz.sender.java.util.Date;
import io.logz.sender.java.util.GregorianCalendar;
import io.logz.sender.java.util.HashMap;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.Locale;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.StringTokenizer;
import io.logz.sender.java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeAdapters
extends Object {
    public static final TypeAdapter<Class> CLASS = new TypeAdapter<Class>(){

        @Override
        public void write(JsonWriter out, Class value) throws IOException {
            if (value != null) {
                throw new UnsupportedOperationException(new StringBuilder().append((String)"io.logz.sender.Attempted to serialize java.lang.Class: ").append(value.getName()).append((String)"io.logz.sender.. Forgot to register a type adapter?").toString());
            }
            out.nullValue();
        }

        @Override
        public Class read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            throw new UnsupportedOperationException((String)"io.logz.sender.Attempted to deserialize a java.lang.Class. Forgot to register a type adapter?");
        }
    };
    public static final TypeAdapterFactory CLASS_FACTORY = TypeAdapters.newFactory(Class.class, CLASS);
    public static final TypeAdapter<BitSet> BIT_SET = new TypeAdapter<BitSet>(){

        @Override
        public BitSet read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            BitSet bitset = new BitSet();
            in.beginArray();
            int i = 0;
            JsonToken tokenType = in.peek();
            while (tokenType != JsonToken.END_ARRAY) {
                boolean set;
                switch (tokenType) {
                    case NUMBER: {
                        set = in.nextInt() != 0;
                        break;
                    }
                    case BOOLEAN: {
                        set = in.nextBoolean();
                        break;
                    }
                    case STRING: {
                        String stringValue = in.nextString();
                        try {
                            set = Integer.parseInt((String)stringValue) != 0;
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new JsonSyntaxException(new StringBuilder().append((String)"io.logz.sender.Error: Expecting: bitset number value (1, 0), Found: ").append(stringValue).toString());
                        }
                    }
                    default: {
                        throw new JsonSyntaxException(new StringBuilder().append((String)"io.logz.sender.Invalid bitset value type: ").append((Object)tokenType).toString());
                    }
                }
                if (set) {
                    bitset.set(i);
                }
                ++i;
                tokenType = in.peek();
            }
            in.endArray();
            return bitset;
        }

        @Override
        public void write(JsonWriter out, BitSet src) throws IOException {
            if (src == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (int i = 0; i < src.length(); ++i) {
                int value = src.get(i) ? 1 : 0;
                out.value(value);
            }
            out.endArray();
        }
    };
    public static final TypeAdapterFactory BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, BIT_SET);
    public static final TypeAdapter<Boolean> BOOLEAN = new TypeAdapter<Boolean>(){

        @Override
        public Boolean read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (in.peek() == JsonToken.STRING) {
                return Boolean.valueOf((boolean)Boolean.parseBoolean((String)in.nextString()));
            }
            return Boolean.valueOf((boolean)in.nextBoolean());
        }

        @Override
        public void write(JsonWriter out, Boolean value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.value(value.booleanValue());
        }
    };
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){

        @Override
        public Boolean read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Boolean.valueOf((String)in.nextString());
        }

        @Override
        public void write(JsonWriter out, Boolean value) throws IOException {
            out.value((String)(value == null ? "io.logz.sender.null" : value.toString()));
        }
    };
    public static final TypeAdapterFactory BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, BOOLEAN);
    public static final TypeAdapter<Number> BYTE = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                int intValue = in.nextInt();
                return Byte.valueOf((byte)((byte)intValue));
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException((Throwable)((java.lang.Object)e));
            }
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapterFactory BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, BYTE);
    public static final TypeAdapter<Number> SHORT = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return Short.valueOf((short)((short)in.nextInt()));
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException((Throwable)((java.lang.Object)e));
            }
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapterFactory SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, SHORT);
    public static final TypeAdapter<Number> INTEGER = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return Integer.valueOf((int)in.nextInt());
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException((Throwable)((java.lang.Object)e));
            }
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapterFactory INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
    public static final TypeAdapter<Number> LONG = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return Long.valueOf((long)in.nextLong());
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException((Throwable)((java.lang.Object)e));
            }
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapter<Number> FLOAT = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Float.valueOf((float)((float)in.nextDouble()));
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapter<Number> DOUBLE = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Double.valueOf((double)in.nextDouble());
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapter<Number> NUMBER = new TypeAdapter<Number>(){

        @Override
        public Number read(JsonReader in) throws IOException {
            JsonToken jsonToken = in.peek();
            switch (jsonToken) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
                case NUMBER: {
                    return new LazilyParsedNumber(in.nextString());
                }
            }
            throw new JsonSyntaxException(new StringBuilder().append((String)"io.logz.sender.Expecting number, got: ").append((Object)jsonToken).toString());
        }

        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapterFactory NUMBER_FACTORY = TypeAdapters.newFactory(Number.class, NUMBER);
    public static final TypeAdapter<Character> CHARACTER = new TypeAdapter<Character>(){

        @Override
        public Character read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String str = in.nextString();
            if (str.length() != 1) {
                throw new JsonSyntaxException(new StringBuilder().append((String)"io.logz.sender.Expecting character, got: ").append(str).toString());
            }
            return Character.valueOf((char)str.charAt(0));
        }

        @Override
        public void write(JsonWriter out, Character value) throws IOException {
            out.value(value == null ? null : String.valueOf((Object)value));
        }
    };
    public static final TypeAdapterFactory CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, CHARACTER);
    public static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        @Override
        public String read(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (peek == JsonToken.BOOLEAN) {
                return Boolean.toString((boolean)in.nextBoolean());
            }
            return in.nextString();
        }

        @Override
        public void write(JsonWriter out, String value) throws IOException {
            out.value(value);
        }
    };
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

        @Override
        public BigDecimal read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return new BigDecimal(in.nextString());
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException((Throwable)((java.lang.Object)e));
            }
        }

        @Override
        public void write(JsonWriter out, BigDecimal value) throws IOException {
            out.value((Number)value);
        }
    };
    public static final TypeAdapter<BigInteger> BIG_INTEGER = new TypeAdapter<BigInteger>(){

        @Override
        public BigInteger read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return new BigInteger(in.nextString());
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException((Throwable)((java.lang.Object)e));
            }
        }

        @Override
        public void write(JsonWriter out, BigInteger value) throws IOException {
            out.value((Number)value);
        }
    };
    public static final TypeAdapterFactory STRING_FACTORY = TypeAdapters.newFactory(String.class, STRING);
    public static final TypeAdapter<StringBuilder> STRING_BUILDER = new TypeAdapter<StringBuilder>(){

        @Override
        public StringBuilder read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new StringBuilder(in.nextString());
        }

        @Override
        public void write(JsonWriter out, StringBuilder value) throws IOException {
            out.value(value == null ? null : value.toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, STRING_BUILDER);
    public static final TypeAdapter<StringBuffer> STRING_BUFFER = new TypeAdapter<StringBuffer>(){

        @Override
        public StringBuffer read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new StringBuffer(in.nextString());
        }

        @Override
        public void write(JsonWriter out, StringBuffer value) throws IOException {
            out.value(value == null ? null : value.toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, STRING_BUFFER);
    public static final TypeAdapter<URL> URL = new TypeAdapter<URL>(){

        @Override
        public URL read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String nextString = in.nextString();
            return "io.logz.sender.null".equals((Object)nextString) ? null : new URL(nextString);
        }

        @Override
        public void write(JsonWriter out, URL value) throws IOException {
            out.value(value == null ? null : value.toExternalForm());
        }
    };
    public static final TypeAdapterFactory URL_FACTORY = TypeAdapters.newFactory(URL.class, URL);
    public static final TypeAdapter<URI> URI = new TypeAdapter<URI>(){

        @Override
        public URI read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                String nextString = in.nextString();
                return "io.logz.sender.null".equals((Object)nextString) ? null : new URI(nextString);
            }
            catch (URISyntaxException e) {
                throw new JsonIOException((Throwable)((java.lang.Object)e));
            }
        }

        @Override
        public void write(JsonWriter out, URI value) throws IOException {
            out.value(value == null ? null : value.toASCIIString());
        }
    };
    public static final TypeAdapterFactory URI_FACTORY = TypeAdapters.newFactory(URI.class, URI);
    public static final TypeAdapter<InetAddress> INET_ADDRESS = new TypeAdapter<InetAddress>(){

        @Override
        public InetAddress read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return InetAddress.getByName((String)in.nextString());
        }

        @Override
        public void write(JsonWriter out, InetAddress value) throws IOException {
            out.value(value == null ? null : value.getHostAddress());
        }
    };
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, INET_ADDRESS);
    public static final TypeAdapter<UUID> UUID = new TypeAdapter<UUID>(){

        @Override
        public UUID read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return io.logz.sender.java.util.UUID.fromString((String)in.nextString());
        }

        @Override
        public void write(JsonWriter out, UUID value) throws IOException {
            out.value(value == null ? null : value.toString());
        }
    };
    public static final TypeAdapterFactory UUID_FACTORY = TypeAdapters.newFactory(UUID.class, UUID);
    public static final TypeAdapterFactory TIMESTAMP_FACTORY = new TypeAdapterFactory(){

        @Override
        public <T extends Object> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.getRawType() != Timestamp.class) {
                return null;
            }
            final TypeAdapter<Date> dateTypeAdapter = gson.getAdapter(Date.class);
            return new TypeAdapter<Timestamp>(){

                @Override
                public Timestamp read(JsonReader in) throws IOException {
                    Date date = (Date)dateTypeAdapter.read(in);
                    return date != null ? new Timestamp(date.getTime()) : null;
                }

                @Override
                public void write(JsonWriter out, Timestamp value) throws IOException {
                    dateTypeAdapter.write(out, value);
                }
            };
        }
    };
    public static final TypeAdapter<Calendar> CALENDAR = new TypeAdapter<Calendar>(){
        private static final String YEAR = "io.logz.sender.year";
        private static final String MONTH = "io.logz.sender.month";
        private static final String DAY_OF_MONTH = "io.logz.sender.dayOfMonth";
        private static final String HOUR_OF_DAY = "io.logz.sender.hourOfDay";
        private static final String MINUTE = "io.logz.sender.minute";
        private static final String SECOND = "io.logz.sender.second";

        @Override
        public Calendar read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            int year = 0;
            int month = 0;
            int dayOfMonth = 0;
            int hourOfDay = 0;
            int minute = 0;
            int second = 0;
            while (in.peek() != JsonToken.END_OBJECT) {
                String name = in.nextName();
                int value = in.nextInt();
                if ("io.logz.sender.year".equals((Object)name)) {
                    year = value;
                    continue;
                }
                if ("io.logz.sender.month".equals((Object)name)) {
                    month = value;
                    continue;
                }
                if ("io.logz.sender.dayOfMonth".equals((Object)name)) {
                    dayOfMonth = value;
                    continue;
                }
                if ("io.logz.sender.hourOfDay".equals((Object)name)) {
                    hourOfDay = value;
                    continue;
                }
                if ("io.logz.sender.minute".equals((Object)name)) {
                    minute = value;
                    continue;
                }
                if (!"io.logz.sender.second".equals((Object)name)) continue;
                second = value;
            }
            in.endObject();
            return new GregorianCalendar(year, month, dayOfMonth, hourOfDay, minute, second);
        }

        @Override
        public void write(JsonWriter out, Calendar value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name((String)"io.logz.sender.year");
            out.value(value.get(1));
            out.name((String)"io.logz.sender.month");
            out.value(value.get(2));
            out.name((String)"io.logz.sender.dayOfMonth");
            out.value(value.get(5));
            out.name((String)"io.logz.sender.hourOfDay");
            out.value(value.get(11));
            out.name((String)"io.logz.sender.minute");
            out.value(value.get(12));
            out.name((String)"io.logz.sender.second");
            out.value(value.get(13));
            out.endObject();
        }
    };
    public static final TypeAdapterFactory CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, CALENDAR);
    public static final TypeAdapter<Locale> LOCALE = new TypeAdapter<Locale>(){

        @Override
        public Locale read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String locale = in.nextString();
            StringTokenizer tokenizer = new StringTokenizer(locale, (String)"io.logz.sender._");
            String language = null;
            String country = null;
            String variant = null;
            if (tokenizer.hasMoreElements()) {
                language = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                country = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                variant = tokenizer.nextToken();
            }
            if (country == null && variant == null) {
                return new Locale(language);
            }
            if (variant == null) {
                return new Locale(language, country);
            }
            return new Locale(language, country, variant);
        }

        @Override
        public void write(JsonWriter out, Locale value) throws IOException {
            out.value(value == null ? null : value.toString());
        }
    };
    public static final TypeAdapterFactory LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, LOCALE);
    public static final TypeAdapter<JsonElement> JSON_ELEMENT = new TypeAdapter<JsonElement>(){

        @Override
        public JsonElement read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case STRING: {
                    return new JsonPrimitive(in.nextString());
                }
                case NUMBER: {
                    String number = in.nextString();
                    return new JsonPrimitive(new LazilyParsedNumber(number));
                }
                case BOOLEAN: {
                    return new JsonPrimitive(Boolean.valueOf((boolean)in.nextBoolean()));
                }
                case NULL: {
                    in.nextNull();
                    return JsonNull.INSTANCE;
                }
                case BEGIN_ARRAY: {
                    JsonArray array = new JsonArray();
                    in.beginArray();
                    while (in.hasNext()) {
                        array.add(this.read(in));
                    }
                    in.endArray();
                    return array;
                }
                case BEGIN_OBJECT: {
                    JsonObject object = new JsonObject();
                    in.beginObject();
                    while (in.hasNext()) {
                        object.add(in.nextName(), this.read(in));
                    }
                    in.endObject();
                    return object;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void write(JsonWriter out, JsonElement value) throws IOException {
            if (value == null || value.isJsonNull()) {
                out.nullValue();
            } else if (value.isJsonPrimitive()) {
                JsonPrimitive primitive = value.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    out.value(primitive.getAsNumber());
                } else if (primitive.isBoolean()) {
                    out.value(primitive.getAsBoolean());
                } else {
                    out.value(primitive.getAsString());
                }
            } else if (value.isJsonArray()) {
                out.beginArray();
                Iterator<JsonElement> i$ = value.getAsJsonArray().iterator();
                while (i$.hasNext()) {
                    JsonElement e = (JsonElement)i$.next();
                    this.write(out, e);
                }
                out.endArray();
            } else if (value.isJsonObject()) {
                out.beginObject();
                for (Map.Entry e : value.getAsJsonObject().entrySet()) {
                    out.name((String)e.getKey());
                    this.write(out, (JsonElement)e.getValue());
                }
                out.endObject();
            } else {
                throw new IllegalArgumentException(new StringBuilder().append((String)"io.logz.sender.Couldn't write ").append((Object)value.getClass()).toString());
            }
        }
    };
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY = TypeAdapters.newTypeHierarchyFactory(JsonElement.class, JSON_ELEMENT);
    public static final TypeAdapterFactory ENUM_FACTORY = new TypeAdapterFactory(){

        @Override
        public <T extends Object> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class rawType = typeToken.getRawType();
            if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                return null;
            }
            if (!rawType.isEnum()) {
                rawType = rawType.getSuperclass();
            }
            return new EnumTypeAdapter(rawType);
        }
    };

    private TypeAdapters() {
    }

    public static <TT extends Object> TypeAdapterFactory newFactory(final TypeToken<TT> type, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T extends Object> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                return typeToken.equals(type) ? typeAdapter : null;
            }
        };
    }

    public static <TT extends Object> TypeAdapterFactory newFactory(final Class<TT> type, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T extends Object> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                return typeToken.getRawType() == type ? typeAdapter : null;
            }

            public String toString() {
                return new StringBuilder().append((String)"io.logz.sender.Factory[type=").append(type.getName()).append((String)"io.logz.sender.,adapter=").append((Object)typeAdapter).append((String)"io.logz.sender.]").toString();
            }
        };
    }

    public static <TT extends Object> TypeAdapterFactory newFactory(final Class<TT> unboxed, final Class<TT> boxed, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T extends Object> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> rawType = typeToken.getRawType();
                return rawType == unboxed || rawType == boxed ? typeAdapter : null;
            }

            public String toString() {
                return new StringBuilder().append((String)"io.logz.sender.Factory[type=").append(boxed.getName()).append((String)"io.logz.sender.+").append(unboxed.getName()).append((String)"io.logz.sender.,adapter=").append((Object)typeAdapter).append((String)"io.logz.sender.]").toString();
            }
        };
    }

    public static <TT extends Object> TypeAdapterFactory newFactoryForMultipleTypes(final Class<TT> base, final Class<? extends TT> sub, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T extends Object> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> rawType = typeToken.getRawType();
                return rawType == base || rawType == sub ? typeAdapter : null;
            }

            public String toString() {
                return new StringBuilder().append((String)"io.logz.sender.Factory[type=").append(base.getName()).append((String)"io.logz.sender.+").append(sub.getName()).append((String)"io.logz.sender.,adapter=").append((Object)typeAdapter).append((String)"io.logz.sender.]").toString();
            }
        };
    }

    public static <TT extends Object> TypeAdapterFactory newTypeHierarchyFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T extends Object> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                return clazz.isAssignableFrom(typeToken.getRawType()) ? typeAdapter : null;
            }

            public String toString() {
                return new StringBuilder().append((String)"io.logz.sender.Factory[typeHierarchy=").append(clazz.getName()).append((String)"io.logz.sender.,adapter=").append((Object)typeAdapter).append((String)"io.logz.sender.]").toString();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<String, T> nameToConstant = new HashMap();
        private final Map<T, String> constantToName = new HashMap();

        public EnumTypeAdapter(Class<T> classOfT) {
            try {
                for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
                    String name = constant.name();
                    SerializedName annotation = (SerializedName)classOfT.getField(name).getAnnotation(SerializedName.class);
                    if (annotation != null) {
                        name = annotation.value();
                    }
                    this.nameToConstant.put((Object)name, (Object)constant);
                    this.constantToName.put((Object)constant, (Object)name);
                }
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError();
            }
        }

        @Override
        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return (T)((Enum)this.nameToConstant.get((Object)in.nextString()));
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            out.value(value == null ? null : (String)this.constantToName.get(value));
        }
    }
}

