/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.logzio.LogzioConfig;
import io.micrometer.logzio.LogzioMeterRegistry;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class MicrometerLogzio {
    MicrometerLogzio() {
    }

    public static void main(String[] args) {
        LogzioConfig logzioConfig = new LogzioConfig(){

            public String get(String key) {
                return null;
            }

            @Override
            public String uri() {
                return "";
            }

            @Override
            public String token() {
                return "";
            }

            public Duration step() {
                return Duration.ofSeconds(5L);
            }

            @Override
            public Hashtable<String, String> includeLabels() {
                Hashtable<String, String> include = new Hashtable<String, String>();
                include.put("__name__", "summary_example_max");
                return include;
            }

            @Override
            public Hashtable<String, String> excludeLabels() {
                Hashtable<String, String> exclude = new Hashtable<String, String>();
                exclude.put("__name__", "summary_example_max");
                return exclude;
            }
        };
        LogzioMeterRegistry registry = new LogzioMeterRegistry(logzioConfig, Clock.SYSTEM);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(Tag.of((String)"env", (String)"dev"));
        Counter counter = Counter.builder((String)"counter_example").description("a description of what this counter does").tags(tags).register((MeterRegistry)registry);
        counter.increment();
        counter.increment(2.0);
        DistributionSummary summary = DistributionSummary.builder((String)"summary_example").description("a description of what this summary does").tags(tags).register((MeterRegistry)registry);
        summary.record(10.0);
        summary.record(20.0);
        summary.record(30.0);
        ArrayList<String> cache = new ArrayList<String>(4);
        Gauge gauge = Gauge.builder((String)"cache_size_gauge_example", cache, List::size).tags(tags).register((MeterRegistry)registry);
        cache.add("1");
        Map map_gauge = registry.gaugeMapSize("map_gauge_example", tags, new HashMap());
        map_gauge.put("key", 1);
        AtomicInteger manual_gauge = (AtomicInteger)registry.gauge("manual_gauge_example", new AtomicInteger(0));
        manual_gauge.set(83);
        Timer timer = Timer.builder((String)"timer_example").description("a description of what this timer does").tags(tags).register((MeterRegistry)registry);
        timer.record(1500L, TimeUnit.MILLISECONDS);
        timer.record(() -> {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

