/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.logzio;

import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.function.Function;

public interface LogzioConfig
extends StepRegistryConfig {
    default public HashMap<String, String> regionsUri() {
        return new HashMap<String, String>(){
            {
                this.put("us", "https://listener.logz.io");
                this.put("ca", "https://listener-ca.logz.io");
                this.put("eu", "https://listener-eu.logz.io");
                this.put("nl", "https://listener-nl.logz.io");
                this.put("uk", "https://listener-uk.logz.io");
                this.put("wa", "https://listener-wa.logz.io");
            }
        };
    }

    default public String prefix() {
        return "logzio";
    }

    default public String uri() {
        HashMap<String, String> regionsToUri;
        String region = this.region();
        if (region != null && (regionsToUri = this.regionsUri()).containsKey(region)) {
            return regionsToUri.get(region) + ":" + this.port();
        }
        return (String)PropertyValidator.getUrlString((MeterRegistryConfig)this, (String)"uri").orElse((Object)("https://listener.logz.io:" + this.port()));
    }

    default public String region() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"region").orElse((Object)"null");
    }

    default public Hashtable<String, String> includeLabels() {
        return new Hashtable<String, String>();
    }

    default public Hashtable<String, String> excludeLabels() {
        return new Hashtable<String, String>();
    }

    default public String token() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"token").required().get();
    }

    default public String port() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"port").orElse((Object)"8053");
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"token", LogzioConfig::token), MeterRegistryConfigValidator.checkRequired((String)"uri", LogzioConfig::uri)});
    }
}

