/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.logzio;

import io.logz.listener.inputs.prometheus.protocol.Remote;
import io.logz.listener.inputs.prometheus.protocol.Types;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.cumulative.CumulativeCounter;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.cumulative.CumulativeTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.CumulativeHistogramLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.push.PushMeterRegistry;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.core.lang.NonNull;
import io.micrometer.core.lang.Nullable;
import io.micrometer.logzio.LogzioConfig;
import io.micrometer.logzio.LogzioNamingConvention;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class LogzioMeterRegistry
extends PushMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("Logzio-metrics-publisher");
    private static final String ERROR_RESPONSE_BODY_SIGNATURE = "\"errors\":true";
    private final Logger logger = LoggerFactory.getLogger(LogzioMeterRegistry.class);
    private int lostItems = 0;
    private final LogzioConfig config;
    private final HttpSender httpClient;
    private static Instant time;

    public LogzioMeterRegistry(LogzioConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    protected LogzioMeterRegistry(LogzioConfig config, Clock clock, ThreadFactory threadFactory, HttpUrlConnectionSender httpClient) {
        super((PushRegistryConfig)config, clock);
        this.config().namingConvention((NamingConvention)new LogzioNamingConvention());
        this.config = config;
        this.httpClient = httpClient;
        this.start(threadFactory);
    }

    protected void publish() {
        String uri = this.config.uri();
        time = Instant.now();
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            try {
                List<Pair<Map<String, String>, Map<Instant, Number>>> requestBody = batch.stream().map(m -> (List)m.match(this::writeGauge, this::writeCounter, this::writeTimer, this::writeSummary, this::writeLongTaskTimer, this::writeTimeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeMeter)).flatMap(Collection::stream).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                List<Pair<Map<String, String>, Map<Instant, Number>>> req = this.filter(requestBody);
                Remote.WriteRequest writeRequest = this.buildRemoteWriteRequest(req);
                AtomicBoolean keepTrying = new AtomicBoolean(true);
                AtomicInteger attempts = new AtomicInteger(1);
                while (keepTrying.get() && attempts.get() < 4) {
                    this.httpClient.post(uri).withContent("application/x-protobuf", Snappy.compress((byte[])writeRequest.toByteArray())).withHeader("Content-Encoding", "snappy").withHeader("Logzio-shipper", String.format("micrometer-registry/1.0.1/%d/%d", attempts.get(), this.lostItems)).withHeader("Authorization", "Bearer " + this.config.token()).send().onSuccess(response -> {
                        String responseBody = response.body();
                        if (responseBody.contains(ERROR_RESPONSE_BODY_SIGNATURE)) {
                            this.logger.info("failed metrics payload: {}", (Object)requestBody);
                            this.lostItems += requestBody.size();
                        } else {
                            this.logger.info("successfully sent metrics");
                            this.lostItems = 0;
                        }
                        keepTrying.set(false);
                    }).onError(response -> {
                        this.logger.debug("failed metrics payload: {}", (Object)requestBody);
                        this.logger.error("failed to send metrics to Logz.io: {}", (Object)response.body());
                        Integer[] RetryStatuses = new Integer[]{408, 500, 502, 503, 504, 522, 524};
                        ArrayList<Integer> RetryStatusesList = new ArrayList<Integer>(Arrays.asList(RetryStatuses));
                        if (!RetryStatusesList.contains(response.code())) {
                            this.logger.warn("Got {} status code, dropping metrics", (Object)response.code());
                            keepTrying.set(false);
                        } else {
                            int backoff = attempts.get() * 2;
                            this.logger.warn("Got {} status code, retrying to send metrics in {} seconds", (Object)response.code(), (Object)backoff);
                            try {
                                Thread.sleep(1000 * backoff);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        if (attempts.get() == 3) {
                            this.logger.warn("Failed to send metrics after 3 attepmts, dropping metrics");
                            this.lostItems += requestBody.size();
                        }
                        attempts.getAndIncrement();
                    });
                }
            }
            catch (Throwable e) {
                this.logger.error("failed to send metrics to Logz.io", e);
            }
        }
    }

    List<Pair<Map<String, String>, Map<Instant, Number>>> filter(List<Pair<Map<String, String>, Map<Instant, Number>>> wr) {
        ArrayList<Pair<Map<String, String>, Map<Instant, Number>>> filteredWr;
        block6: {
            Hashtable<String, String> exclude;
            block5: {
                filteredWr = new ArrayList<Pair<Map<String, String>, Map<Instant, Number>>>(wr);
                Hashtable<String, String> include = this.config.includeLabels();
                exclude = this.config.excludeLabels();
                if (include.isEmpty()) break block5;
                for (Pair<Map<String, String>, Map<Instant, Number>> ts : wr) {
                    HashMap labels = (HashMap)ts.getValue0();
                    for (String labelKey : include.keySet()) {
                        if (labels.keySet().contains(labelKey)) {
                            String regexPattern = include.get(labelKey);
                            String value = (String)labels.get(labelKey);
                            if (value.matches(regexPattern)) continue;
                            filteredWr.remove(ts);
                            continue;
                        }
                        filteredWr.remove(ts);
                    }
                }
                break block6;
            }
            if (exclude.isEmpty()) break block6;
            for (Pair<Map<String, String>, Map<Instant, Number>> ts : wr) {
                HashMap labels = (HashMap)ts.getValue0();
                for (String labelKey : exclude.keySet()) {
                    if (!labels.keySet().contains(labelKey)) continue;
                    String regexPattern = exclude.get(labelKey);
                    String value = (String)labels.get(labelKey);
                    if (!value.matches(regexPattern)) continue;
                    filteredWr.remove(ts);
                }
            }
        }
        return filteredWr;
    }

    List<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> writeCounter(Counter counter) {
        return this.writeCounter((Meter)counter, counter.count());
    }

    List<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> writeFunctionCounter(FunctionCounter counter) {
        return this.writeCounter((Meter)counter, counter.count());
    }

    private List<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> writeCounter(Meter meter, Double value) {
        if (Double.isFinite(value)) {
            return Arrays.asList(Optional.of(this.writeDocument(meter, value, "")));
        }
        return Arrays.asList(Optional.empty());
    }

    List<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> writeGauge(Gauge gauge) {
        double value = gauge.value();
        if (Double.isFinite(value)) {
            return Arrays.asList(Optional.of(this.writeDocument((Meter)gauge, value, "")));
        }
        return Arrays.asList(Optional.empty());
    }

    List<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> writeTimeGauge(TimeGauge gauge) {
        double value = gauge.value(this.getBaseTimeUnit());
        if (Double.isFinite(value)) {
            return Arrays.asList(Optional.of(this.writeDocument((Meter)gauge, value, "")));
        }
        return Arrays.asList(Optional.empty());
    }

    List<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> writeFunctionTimer(FunctionTimer timer) {
        double sum = timer.totalTime(this.getBaseTimeUnit());
        double mean = timer.mean(this.getBaseTimeUnit());
        if (Double.isFinite(sum) && Double.isFinite(mean)) {
            return Arrays.asList(Optional.of(this.writeDocument((Meter)timer, timer.count(), "_count")), Optional.of(this.writeDocument((Meter)timer, timer.totalTime(this.getBaseTimeUnit()), "_sum")));
        }
        return Arrays.asList(Optional.empty());
    }

    List<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> writeLongTaskTimer(LongTaskTimer timer) {
        return Arrays.asList(Optional.of(this.writeDocument((Meter)timer, timer.duration(this.getBaseTimeUnit()), "_sum")), Optional.of(this.writeDocument((Meter)timer, timer.max(this.getBaseTimeUnit()), "_max")), Optional.of(this.writeDocument((Meter)timer, timer.activeTasks(), "_count")));
    }

    List<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> writeTimer(Timer timer) {
        return Arrays.asList(Optional.of(this.writeDocument((Meter)timer, timer.count(), "_count")), Optional.of(this.writeDocument((Meter)timer, timer.max(this.getBaseTimeUnit()), "_max")), Optional.of(this.writeDocument((Meter)timer, timer.totalTime(this.getBaseTimeUnit()), "_sum")));
    }

    List<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> writeSummary(DistributionSummary summary) {
        HistogramSnapshot histogramSnapshot = summary.takeSnapshot();
        ArrayList<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> list = new ArrayList<Optional<Pair<Map<String, String>, Map<Instant, Number>>>>(Arrays.asList(Optional.of(this.writeDocument((Meter)summary, histogramSnapshot.max(), "_max")), Optional.of(this.writeDocument((Meter)summary, histogramSnapshot.total(), "_sum")), Optional.of(this.writeDocument((Meter)summary, histogramSnapshot.count(), "_count"))));
        return list;
    }

    List<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> writeMeter(Meter meter) {
        Iterable measurements = meter.measure();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (Measurement measurement : measurements) {
            double value = measurement.getValue();
            if (!Double.isFinite(value)) continue;
            names.add(measurement.getStatistic().getTagValueRepresentation());
            values.add(value);
        }
        if (names.isEmpty()) {
            return Arrays.asList(Optional.empty());
        }
        ArrayList<Optional<Pair<Map<String, String>, Map<Instant, Number>>>> metersList = new ArrayList<Optional<Pair<Map<String, String>, Map<Instant, Number>>>>();
        for (int i = 0; i < names.size(); ++i) {
            metersList.add(Optional.of(this.writeDocument(meter, (Number)values.get(i), "_" + (String)names.get(i))));
        }
        return metersList;
    }

    Pair<Map<String, String>, Map<Instant, Number>> writeDocument(Meter meter, Number value, String type) {
        HashMap<String, String> labels = new HashMap<String, String>();
        HashMap<Instant, Number> samples = new HashMap<Instant, Number>();
        labels.put("__name__", StringEscapeUtils.escapeJson((String)this.getConventionName(meter.getId())) + type);
        this.getConventionTags(meter.getId()).forEach(tag -> labels.put(tag.getKey(), tag.getValue()));
        samples.put(time, value);
        return new Pair(labels, samples);
    }

    public static void setTime(Instant newTime) {
        time = newTime;
    }

    public void setLostItems(int lost) {
        this.lostItems = lost;
    }

    public Counter newCounter(Meter.Id id) {
        return new CumulativeCounter(id);
    }

    public DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new CumulativeDistributionSummary(id, this.clock, distributionStatisticConfig, scale);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new CumulativeTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit());
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return new CumulativeHistogramLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig);
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new CumulativeFunctionCounter(id, obj, countFunction);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    @NonNull
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    private Remote.WriteRequest buildRemoteWriteRequest(List<Pair<Map<String, String>, Map<Instant, Number>>> labelsSamplesPairs) {
        return Remote.WriteRequest.newBuilder().addAllTimeseries(labelsSamplesPairs.stream().map(labels -> Types.TimeSeries.newBuilder().addAllLabels(this.getLabels((Map)labels.getValue0())).addAllSamples(this.getSamples((Map)labels.getValue1())).build()).collect(Collectors.toList())).build();
    }

    private List<Types.Label> getLabels(Map<String, String> labels) {
        return labels.entrySet().stream().map(entry -> Types.Label.newBuilder().setName((String)entry.getKey()).setValue((String)entry.getValue()).build()).collect(Collectors.toList());
    }

    private List<Types.Sample> getSamples(Map<Instant, Number> samples) {
        return samples.entrySet().stream().map(entry -> Types.Sample.newBuilder().setTimestampMillis(((Instant)entry.getKey()).toEpochMilli()).setValue(((Number)entry.getValue()).doubleValue()).build()).collect(Collectors.toList());
    }
}

