/*
 * Decompiled with CFR 0.152.
 */
package io.logz.test;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class TestEnvironment {
    public static File createTempDirectory() {
        String mavenBuildDirectory = "target";
        String buildDirSubString = File.separator + "target" + File.separator;
        String classPath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        List paths = Splitter.on((String)separator).trimResults().splitToList((CharSequence)classPath);
        File buildDir = paths.stream().filter(path -> path.contains(buildDirSubString)).findFirst().map(path -> {
            String upToBuildDir = path.substring(0, path.indexOf(buildDirSubString) + buildDirSubString.length());
            return new File(upToBuildDir);
        }).orElseThrow(() -> new RuntimeException("Failed finding classpath entry containing the build directory (" + buildDirSubString + " in the following classpath: " + classPath));
        try {
            FileAttribute<Set<PosixFilePermission>> fileAttributes = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE}));
            return Files.createTempDirectory(buildDir.toPath(), "", fileAttributes).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed creating temp directory in " + buildDir.getAbsolutePath(), e);
        }
    }
}

