/*
 * Decompiled with CFR 0.152.
 */
package io.logz.test;

import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockLogzioBulkListener
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MockLogzioBulkListener.class);
    private static final String LISTENER_ADDRESS = "localhost";
    private Server server;
    private Queue<LogRequest> logRequests = new ConcurrentLinkedQueue<LogRequest>();
    private final String host;
    private final int port = this.findFreePort();
    private int malformedLogs = 0;
    private boolean isServerTimeoutMode = false;
    private boolean raiseExceptionOnLog = false;
    private int timeoutMillis = 10000;

    public void setFailWithServerError(boolean raiseExceptionOnLog) {
        this.raiseExceptionOnLog = raiseExceptionOnLog;
    }

    public void setServerTimeoutMode(boolean serverTimeoutMode) {
        this.isServerTimeoutMode = serverTimeoutMode;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public MockLogzioBulkListener() throws IOException {
        this.host = LISTENER_ADDRESS;
        this.server = new Server(new InetSocketAddress(this.host, this.port));
        this.server.setHandler((Handler)new AbstractHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                logger.debug("got request with query string: {} ({})", (Object)request.getQueryString(), (Object)this);
                if (MockLogzioBulkListener.this.isServerTimeoutMode) {
                    try {
                        Thread.sleep(MockLogzioBulkListener.this.timeoutMillis);
                        baseRequest.setHandled(true);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try (Stream<String> logStream = MockLogzioBulkListener.this.getLogsStream(request);){
                    logStream.forEach(line -> {
                        if (MockLogzioBulkListener.this.raiseExceptionOnLog) {
                            throw new RuntimeException();
                        }
                        String queryString = request.getQueryString();
                        LogRequest tmpRequest = new LogRequest(queryString, (String)line);
                        MockLogzioBulkListener.this.logRequests.add(tmpRequest);
                        logger.debug("got log: {} ", line);
                    });
                    logger.debug("Total number of logRequests {} ({})", (Object)MockLogzioBulkListener.this.logRequests.size(), MockLogzioBulkListener.this.logRequests);
                }
                catch (IllegalArgumentException e) {
                    ++MockLogzioBulkListener.this.malformedLogs;
                    response.setStatus(400);
                }
                finally {
                    baseRequest.setHandled(true);
                }
            }
        });
        logger.info("Created a mock listener (" + String.valueOf(this) + ")");
    }

    private Stream<String> getLogsStream(HttpServletRequest request) throws IOException {
        String contentEncoding = request.getHeader("Content-Encoding");
        if (contentEncoding != null && request.getHeader("Content-Encoding").equals("gzip")) {
            GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)request.getInputStream());
            InputStreamReader decoder = new InputStreamReader((InputStream)gzipInputStream, "UTF-8");
            BufferedReader br = new BufferedReader(decoder);
            return br.lines();
        }
        return request.getReader().lines();
    }

    private int findFreePort() throws IOException {
        int attempts = 1;
        int port = -1;
        while (attempts <= 3) {
            int availablePort = -1;
            try {
                ServerSocket serverSocket = new ServerSocket(0);
                serverSocket.close();
                port = availablePort = serverSocket.getLocalPort();
                break;
            }
            catch (BindException e) {
                if (attempts++ == 3) {
                    throw new RuntimeException("Failed to get a non busy port: " + availablePort, e);
                }
                logger.info("Failed to start mock listener on port {}", (Object)availablePort);
            }
        }
        return port;
    }

    public void start() throws Exception {
        logger.info("Starting MockLogzioBulkListener");
        this.server.start();
        int attempts = 1;
        while (!this.server.isRunning()) {
            logger.info("Server has not started yet");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
            if (++attempts <= 10) continue;
            throw new RuntimeIOException("Failed to start after multiple attempts");
        }
        logger.info("Started listening on {}:{} ({})", new Object[]{this.host, this.port, this});
    }

    public void stop() {
        logger.info("Stopping MockLogzioBulkListener");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int attempts = 1;
        while (this.server.isRunning()) {
            logger.info("Server has not stopped yet");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
            if (++attempts <= 10) continue;
            throw new RuntimeIOException("Failed to stop after multiple attempts");
        }
        logger.info("Stopped listening on {}:{} ({})", new Object[]{this.host, this.port, this});
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public Collection<LogRequest> getReceivedMsgs() {
        return Collections.unmodifiableCollection(this.logRequests);
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public Optional<LogRequest> getLogByMessageField(String msg) {
        return this.logRequests.stream().filter(r -> r.getMessage() != null && r.getMessage().equals(msg)).findFirst();
    }

    public int getNumberOfReceivedLogs() {
        return this.logRequests.size();
    }

    public int getNumberOfReceivedMalformedLogs() {
        return this.malformedLogs;
    }

    public LogRequest assertLogReceivedByMessage(String message) {
        Optional<LogRequest> logRequest = this.getLogByMessageField(message);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)logRequest.isPresent()).describedAs("Log with message '" + message + "' received", new Object[0])).isTrue();
        return logRequest.get();
    }

    public void assertNumberOfReceivedMsgs(int count) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getNumberOfReceivedLogs()).describedAs("Messages on mock listener: {}", new Object[]{this.getReceivedMsgs()})).isEqualTo(count);
    }

    public void assertNumberOfReceivedMalformedMsgs(int count) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getNumberOfReceivedMalformedLogs()).describedAs("Malformed messages on mock listener: {}", new Object[]{this.malformedLogs})).isEqualTo(count);
    }

    public void assertLogReceivedIs(String message, String token, String type, String loggerName, String level) {
        LogRequest log = this.assertLogReceivedByMessage(message);
        this.assertLogReceivedIs(log, token, type, loggerName, level);
    }

    public void assertLogReceivedIs(LogRequest log, String token, String type, String loggerName, String level) {
        Assertions.assertThat((String)log.getToken()).isEqualTo((Object)token);
        Assertions.assertThat((String)log.getType()).isEqualTo((Object)type);
        Assertions.assertThat((String)log.getLogger()).isEqualTo((Object)loggerName);
        Assertions.assertThat((String)log.getLogLevel()).isEqualTo((Object)level);
    }

    public static class LogRequest {
        private final String token;
        private final String type;
        private final JsonObject jsonObject;

        public LogRequest(String queryString, String logLine) {
            Map paramToValueMap = Splitter.on((char)'&').withKeyValueSeparator('=').split((CharSequence)queryString);
            if (!paramToValueMap.containsKey("token")) {
                throw new IllegalArgumentException("Token not found in query string: " + queryString);
            }
            this.token = (String)paramToValueMap.get("token");
            if (!paramToValueMap.containsKey("type")) {
                throw new IllegalArgumentException("Token not found in query string: " + queryString);
            }
            this.type = (String)paramToValueMap.get("type");
            try {
                this.jsonObject = new JsonParser().parse(logLine).getAsJsonObject();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Not a valid json received in body of request. logLine = " + logLine, e);
            }
        }

        public String getToken() {
            return this.token;
        }

        public String getType() {
            return this.type;
        }

        public JsonObject getJsonObject() {
            return this.jsonObject;
        }

        public String getMessage() {
            return this.getStringFieldOrNull("message");
        }

        public String getLogger() {
            return this.getStringFieldOrNull("logger");
        }

        public String getLogLevel() {
            return this.getStringFieldOrNull("loglevel");
        }

        public String getHost() {
            return this.getStringFieldOrNull("hostname");
        }

        public String getStringFieldOrNull(String fieldName) {
            if (this.jsonObject.get(fieldName) == null) {
                return null;
            }
            return this.jsonObject.get(fieldName).getAsString();
        }

        public String toString() {
            return "[Token = " + this.token + ", type = " + this.type + "]: " + this.jsonObject.toString();
        }
    }
}

