/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.org.kairosdb.metrics4j.configuration;

import io.logz.sender.org.kairosdb.metrics4j.MetricsContext;
import io.logz.sender.org.kairosdb.metrics4j.configuration.ConfigurationException;
import io.logz.sender.org.kairosdb.metrics4j.configuration.PluginClassLoader;
import io.logz.sender.org.kairosdb.metrics4j.configuration.ShutdownHookOverride;
import io.logz.sender.org.kairosdb.metrics4j.internal.ArgKey;
import io.logz.sender.org.kairosdb.metrics4j.internal.BeanInjector;
import io.logz.sender.org.kairosdb.metrics4j.internal.MetricsContextImpl;
import io.logz.sender.org.kairosdb.metrics4j.shaded.config.Config;
import io.logz.sender.org.kairosdb.metrics4j.shaded.config.ConfigFactory;
import io.logz.sender.org.kairosdb.metrics4j.shaded.config.ConfigRenderOptions;
import io.logz.sender.org.kairosdb.metrics4j.shaded.config.ConfigValue;
import io.logz.sender.org.kairosdb.metrics4j.shaded.config.ConfigValueType;
import java.beans.IntrospectionException;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricConfig {
    public static final String CLASS_PROPERTY = "_class";
    public static final String FOLDER_PROPERTY = "_folder";
    public static final String DUMP_FILE = "_dump-file";
    public static final String METRIC_NAME = "_metric-name";
    private static Logger log = LoggerFactory.getLogger(MetricConfig.class);
    private static final Pattern formatPattern = Pattern.compile("\\%\\{([^\\}]*)\\}");
    private Properties m_properties = new Properties();
    private final Map<List<String>, Map<String, String>> m_mappedTags;
    private final Map<List<String>, Map<String, String>> m_mappedProps;
    private final Map<List<String>, String> m_mappedMetricNames;
    private final Map<List<String>, Boolean> m_disabledPaths;
    private final MetricsContextImpl m_context;
    private final List<Closeable> m_closeables;
    private boolean m_shutdownOverride = false;
    private boolean m_dumpMetrics = false;
    private String m_dumpFile;
    private Map<String, Object> m_dumpConfig;

    private String formatValue(String value) {
        Matcher matcher = formatPattern.matcher(value);
        StringBuilder sb = new StringBuilder();
        int endLastMatch = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (start != endLastMatch) {
                sb.append(value, endLastMatch, start);
            }
            String token = matcher.group(1);
            sb.append(this.m_properties.getProperty(token, "%{" + token + "}"));
            endLastMatch = end;
        }
        sb.append(value.substring(endLastMatch));
        return sb.toString();
    }

    private <T> T loadClass(Config config, String objName) {
        Object ret = null;
        String className = config.getString(CLASS_PROPERTY);
        try {
            ClassLoader pluginLoader = MetricConfig.class.getClassLoader();
            if (config.hasPath(FOLDER_PROPERTY)) {
                String pluginFolder = config.getString(FOLDER_PROPERTY);
                pluginLoader = new PluginClassLoader(MetricConfig.getJarsInPath(pluginFolder), pluginLoader);
            }
            Class<?> pluginClass = pluginLoader.loadClass(className);
            BeanInjector beanInjector = new BeanInjector(objName, pluginClass);
            ret = beanInjector.createInstance(config);
        }
        catch (IntrospectionException | ClassNotFoundException | MalformedURLException e) {
            throw new ConfigurationException("Unable to load plugin '" + objName + "' '" + className + "' for configuration element '" + config.origin().lineNumber() + "'");
        }
        return (T)ret;
    }

    private static URL[] getJarsInPath(String path) throws MalformedURLException {
        ArrayList<URL> jars = new ArrayList<URL>();
        File libDir = new File(path);
        File[] fileList = libDir.listFiles();
        if (fileList != null) {
            for (File f : fileList) {
                if (!f.getName().endsWith(".jar")) continue;
                jars.add(f.toURI().toURL());
            }
        }
        return jars.toArray(new URL[0]);
    }

    private <T> void registerStuff(Config configs, BiConsumer<String, T> register) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, ConfigValue> config : configs.entrySet()) {
            keys.add(config.getKey().split("\\.")[0]);
        }
        for (String name : keys) {
            T classInstance = this.loadClass(configs.getConfig(name), name);
            register.accept(name, (String)classInstance);
            if (!(classInstance instanceof Closeable)) continue;
            this.m_closeables.add((Closeable)classInstance);
        }
    }

    static List<String> appendSourceName(List<String> parent, String child) {
        ArrayList<String> copy = new ArrayList<String>(parent);
        String[] splitNames = child.split("\\.");
        copy.addAll(Arrays.asList(splitNames));
        return copy;
    }

    private String combinePath(String[] path, int limit) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < limit; ++i) {
            sb.append(path[i]).append(".");
        }
        sb.append(path[limit]);
        return sb.toString();
    }

    private List<String> createList(String[] arr, int limit) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i <= limit; ++i) {
            ret.add(arr[i]);
        }
        return ret;
    }

    private void parseSources(Config root) {
        if (root == null) {
            throw new ConfigurationException("No 'sources' element in your configuration");
        }
        Set<Map.Entry<String, ConfigValue>> entries = root.entrySet();
        for (Map.Entry<String, ConfigValue> entry : entries) {
            String[] path = entry.getKey().split("\\.");
            for (int i = path.length - 1; i >= 0; --i) {
                List<String> pathList;
                String value;
                String key;
                String ref;
                String ref2;
                if (!path[i].startsWith("_")) continue;
                String internalProp = path[i];
                if (internalProp.equals(METRIC_NAME)) {
                    String combinedPath = this.combinePath(path, i);
                    String metricName = root.getString(combinedPath);
                    if (metricName.isEmpty()) continue;
                    this.m_mappedMetricNames.put(this.createList(path, i - 1), metricName);
                    continue;
                }
                if (internalProp.equals("_sink")) {
                    String sinkPath = this.combinePath(path, i);
                    ConfigValueType sinkValueType = root.getValue(sinkPath).valueType();
                    if (sinkValueType == ConfigValueType.STRING) {
                        ref2 = root.getString(sinkPath);
                        this.m_context.addSinkToPath(ref2, this.createList(path, i - 1));
                        continue;
                    }
                    if (sinkValueType != ConfigValueType.LIST) continue;
                    List<String> sinkList = root.getStringList(sinkPath);
                    for (String sink : sinkList) {
                        this.m_context.addSinkToPath(sink, this.createList(path, i - 1));
                    }
                    continue;
                }
                if (internalProp.equals("_collector")) {
                    String collectorPath = this.combinePath(path, i);
                    ConfigValueType collectorValueType = root.getValue(collectorPath).valueType();
                    if (collectorValueType == ConfigValueType.STRING) {
                        ref2 = root.getString(collectorPath);
                        this.m_context.addCollectorToPath(ref2, this.createList(path, i - 1));
                        continue;
                    }
                    if (collectorValueType != ConfigValueType.LIST) continue;
                    List<String> collectorList = root.getStringList(collectorPath);
                    for (String collector : collectorList) {
                        this.m_context.addCollectorToPath(collector, this.createList(path, i - 1));
                    }
                    continue;
                }
                if (internalProp.equals("_formatter")) {
                    ref = root.getString(this.combinePath(path, i));
                    this.m_context.addFormatterToPath(ref, this.createList(path, i - 1));
                    continue;
                }
                if (internalProp.equals("_trigger")) {
                    ref = root.getString(this.combinePath(path, i));
                    this.m_context.addTriggerToPath(ref, this.createList(path, i - 1));
                    continue;
                }
                if (internalProp.equals("_tags")) {
                    key = path[i + 1];
                    value = (String)entry.getValue().unwrapped();
                    pathList = this.createList(path, i - 1);
                    Map pathTags = this.m_mappedTags.computeIfAbsent(pathList, k -> new HashMap());
                    pathTags.put(key, value);
                    continue;
                }
                if (internalProp.equals("_prop")) {
                    key = path[i + 1];
                    value = (String)entry.getValue().unwrapped();
                    pathList = this.createList(path, i - 1);
                    Map pathProps = this.m_mappedProps.computeIfAbsent(pathList, k -> new HashMap());
                    pathProps.put(key, value);
                    continue;
                }
                if (internalProp.equals("_disabled")) {
                    Boolean value2 = (Boolean)entry.getValue().unwrapped();
                    this.m_disabledPaths.put(this.createList(path, i - 1), value2);
                    continue;
                }
                throw new ConfigurationException("Unknown configuration element: " + internalProp);
            }
        }
    }

    private static void registerIfNotNull(Config config, String path, Consumer<Config> register) {
        if (config.hasPath(path)) {
            register.accept(config.getConfig(path));
        }
    }

    public static MetricConfig parseConfig(String baseConfig, String overridesConfig) {
        MetricsContextImpl context = new MetricsContextImpl();
        MetricConfig ret = new MetricConfig(context);
        Config base = ConfigFactory.parseResources(baseConfig);
        Config overrides = ConfigFactory.parseResources(overridesConfig);
        Config config = overrides.withFallback(base).resolve();
        if (config.hasPath("metrics4j")) {
            Config metrics4j = config.getConfig("metrics4j");
            MetricConfig.registerIfNotNull(config, "metrics4j.sinks", sinks -> ret.registerStuff((Config)sinks, context::registerSink));
            MetricConfig.registerIfNotNull(config, "metrics4j.collectors", collectors -> ret.registerStuff((Config)collectors, context::registerCollector));
            MetricConfig.registerIfNotNull(config, "metrics4j.formatters", formatters -> ret.registerStuff((Config)formatters, context::registerFormatter));
            MetricConfig.registerIfNotNull(config, "metrics4j.triggers", triggers -> ret.registerStuff((Config)triggers, context::registerTrigger));
            if (metrics4j.hasPath(DUMP_FILE)) {
                ret.m_dumpFile = metrics4j.getString(DUMP_FILE);
                ret.m_dumpMetrics = true;
                ret.m_dumpConfig = new HashMap<String, Object>();
            }
            MetricConfig.registerIfNotNull(config, "metrics4j.sources", sources -> ret.parseSources((Config)sources));
        }
        return ret;
    }

    public MetricConfig(MetricsContextImpl context) {
        this.m_context = context;
        this.m_closeables = new ArrayList<Closeable>();
        this.m_mappedTags = new HashMap<List<String>, Map<String, String>>();
        this.m_mappedProps = new HashMap<List<String>, Map<String, String>>();
        this.m_mappedMetricNames = new HashMap<List<String>, String>();
        this.m_disabledPaths = new HashMap<List<String>, Boolean>();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (!MetricConfig.this.m_shutdownOverride) {
                    MetricConfig.this.shutdown();
                }
            }
        }));
    }

    private void shutdown() {
        log.debug("Shutdown called for Metrics4j");
        for (Closeable closeable : this.m_closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.error("Error closing " + closeable.getClass().getName(), (Throwable)e);
            }
        }
        if (this.m_dumpFile != null) {
            log.debug("Writing dump file {}", (Object)this.m_dumpFile);
            try {
                Map<String, Object> metrics4j = this.getAdd(this.m_dumpConfig, "metrics4j");
                this.getAdd(metrics4j, "sources");
                this.getAdd(metrics4j, "sinks");
                this.getAdd(metrics4j, "collectors");
                this.getAdd(metrics4j, "formatters");
                this.getAdd(metrics4j, "triggers");
                String dumpConfigStr = ConfigFactory.parseMap(this.m_dumpConfig).root().render(ConfigRenderOptions.defaults().setOriginComments(false).setJson(false));
                FileWriter out = new FileWriter(this.m_dumpFile);
                out.write(dumpConfigStr);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ShutdownHookOverride getShutdownHookOverride() {
        this.m_shutdownOverride = true;
        return this::shutdown;
    }

    public String getMetricNameForKey(ArgKey key) {
        return this.m_mappedMetricNames.get(key.getConfigPath());
    }

    public MetricsContext getContext() {
        return this.m_context;
    }

    public void setProperties(Properties properties) {
        this.m_properties = properties;
    }

    public boolean isDisabled(ArgKey argKey) {
        List<String> configPath = argKey.getConfigPath();
        for (int i = configPath.size(); i >= 0; --i) {
            ArrayList<String> searchPath = new ArrayList<String>(configPath.subList(0, i));
            Boolean disabled = this.m_disabledPaths.get(searchPath);
            if (disabled == null) continue;
            return disabled;
        }
        return false;
    }

    public Map<String, String> getTagsForKey(ArgKey argKey) {
        return this.getValuesForKey(argKey, this.m_mappedTags);
    }

    private Map<String, String> getValuesForKey(ArgKey argKey, Map<List<String>, Map<String, String>> mappedTags) {
        HashMap<String, String> ret = new HashMap<String, String>();
        List<String> configPath = argKey.getConfigPath();
        for (int i = configPath.size(); i >= 0; --i) {
            ArrayList<String> searchPath = new ArrayList<String>(configPath.subList(0, i));
            Map pathTags = mappedTags.getOrDefault(searchPath, new HashMap());
            for (String key : pathTags.keySet()) {
                ret.putIfAbsent(this.formatValue(key), this.formatValue((String)pathTags.get(key)));
            }
        }
        return ret;
    }

    public Map<String, String> getPropsForKey(ArgKey argKey) {
        return this.getValuesForKey(argKey, this.m_mappedProps);
    }

    public boolean isDumpMetrics() {
        return this.m_dumpMetrics;
    }

    private Map<String, Object> getAdd(Map<String, Object> root, String segment) {
        return (Map)root.computeIfAbsent(segment, s -> new HashMap());
    }

    public void addDumpSource(String src, String helpText) {
        Map<String, Object> sources = this.getAdd(this.getAdd(this.m_dumpConfig, "metrics4j"), "sources");
        String[] split = src.split("\\.");
        for (int i = 0; i < split.length; ++i) {
            sources = this.getAdd(sources, split[i]);
        }
    }
}

