/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.org.kairosdb.metrics4j.internal;

import io.logz.sender.org.kairosdb.metrics4j.collectors.Collector;
import io.logz.sender.org.kairosdb.metrics4j.collectors.MetricCollector;
import io.logz.sender.org.kairosdb.metrics4j.internal.ArgKey;
import io.logz.sender.org.kairosdb.metrics4j.internal.CollectorCollection;
import io.logz.sender.org.kairosdb.metrics4j.internal.MetricsGatherer;
import io.logz.sender.org.kairosdb.metrics4j.internal.TagKey;
import java.util.HashMap;
import java.util.Map;

public class CollectorCollectionAdapter
extends MetricsGatherer
implements CollectorCollection {
    private final Collector m_baseCollector;
    private final Map<TagKey, MetricCollector> m_collectors;
    private final ArgKey m_argKey;

    public CollectorCollectionAdapter(Collector baseCollector, ArgKey argKey) {
        this.m_baseCollector = baseCollector;
        this.m_argKey = argKey;
        this.m_collectors = new HashMap<TagKey, MetricCollector>();
    }

    private MetricCollector newCollector(TagKey tagKey) {
        return this.m_baseCollector.clone();
    }

    void addCollector(TagKey tagKey, MetricCollector collector) {
        this.m_collectors.put(tagKey, collector);
    }

    @Override
    public MetricCollector getCollector(TagKey tagKey) {
        return this.m_collectors.computeIfAbsent(tagKey, tk -> this.newCollector((TagKey)tk));
    }

    @Override
    protected ArgKey getArgKey() {
        return this.m_argKey;
    }

    @Override
    protected Map<TagKey, MetricCollector> getCollectors() {
        return this.m_collectors;
    }
}

