/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.org.kairosdb.metrics4j.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapCombiner<K, V>
implements Map<K, V> {
    private final Map<K, V> m_first;
    private final Map<K, V> m_second;

    public MapCombiner(Map<K, V> first, Map<K, V> second) {
        this.m_first = first;
        this.m_second = second;
    }

    @Override
    public int size() {
        return this.m_first.size() + this.m_second.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_first.isEmpty() && this.m_second.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_first.containsKey(key) || this.m_second.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_first.containsValue(value) || this.m_second.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V ret = this.m_first.get(key);
        if (ret == null) {
            ret = this.m_second.get(key);
        }
        return ret;
    }

    @Override
    public V put(K key, V value) {
        return null;
    }

    @Override
    public V remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> ret = new HashSet<K>(this.m_second.keySet());
        ret.addAll(this.m_first.keySet());
        return ret;
    }

    @Override
    public Collection<V> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> ret = new HashSet<Map.Entry<K, V>>(this.m_second.entrySet());
        ret.addAll(this.m_first.entrySet());
        return ret;
    }

    public String toString() {
        return "MapCombiner(m_first=" + this.m_first + ", m_second=" + this.m_second + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapCombiner)) {
            return false;
        }
        MapCombiner other = (MapCombiner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<K, V> this$m_first = this.m_first;
        Map<K, V> other$m_first = other.m_first;
        if (this$m_first == null ? other$m_first != null : !((Object)this$m_first).equals(other$m_first)) {
            return false;
        }
        Map<K, V> this$m_second = this.m_second;
        Map<K, V> other$m_second = other.m_second;
        return !(this$m_second == null ? other$m_second != null : !((Object)this$m_second).equals(other$m_second));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MapCombiner;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<K, V> $m_first = this.m_first;
        result = result * 59 + ($m_first == null ? 43 : ((Object)$m_first).hashCode());
        Map<K, V> $m_second = this.m_second;
        result = result * 59 + ($m_second == null ? 43 : ((Object)$m_second).hashCode());
        return result;
    }
}

