/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.org.kairosdb.metrics4j.internal;

import io.logz.sender.org.kairosdb.metrics4j.reporting.MetricValue;
import io.logz.sender.org.kairosdb.metrics4j.reporting.ReportedMetric;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ReportedMetricImpl
implements ReportedMetric {
    private Instant m_time;
    private String m_className;
    private String m_methodName;
    private Map<String, String> m_tags = Collections.emptyMap();
    private List<ReportedMetric.Sample> m_samples = new ArrayList<ReportedMetric.Sample>();

    public ReportedMetricImpl setTime(Instant time) {
        this.m_time = time;
        return this;
    }

    @Override
    public String getClassName() {
        return this.m_className;
    }

    public ReportedMetricImpl setClassName(String className) {
        this.m_className = className;
        return this;
    }

    @Override
    public String getMethodName() {
        return this.m_methodName;
    }

    public ReportedMetricImpl setMethodName(String methodName) {
        this.m_methodName = methodName;
        return this;
    }

    @Override
    public Map<String, String> getTags() {
        return this.m_tags;
    }

    public ReportedMetricImpl setTags(Map<String, String> tags) {
        this.m_tags = tags;
        return this;
    }

    public ReportedMetricImpl addTags(Map<String, String> tags) {
        this.m_tags.putAll(tags);
        return this;
    }

    public ReportedMetricImpl addSample(String fieldName, MetricValue value) {
        this.m_samples.add(new SampleImpl(fieldName, value));
        return this;
    }

    public ReportedMetricImpl addSample(String fieldName, MetricValue value, Instant time) {
        this.m_samples.add(new SampleImpl(fieldName, value, time));
        return this;
    }

    @Override
    public List<ReportedMetric.Sample> getSamples() {
        return this.m_samples;
    }

    public String toString() {
        return "ReportedMetricImpl(m_time=" + this.m_time + ", m_className=" + this.m_className + ", m_methodName=" + this.m_methodName + ", m_tags=" + this.m_tags + ", m_samples=" + this.m_samples + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportedMetricImpl)) {
            return false;
        }
        ReportedMetricImpl other = (ReportedMetricImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Instant this$m_time = this.m_time;
        Instant other$m_time = other.m_time;
        if (this$m_time == null ? other$m_time != null : !((Object)this$m_time).equals(other$m_time)) {
            return false;
        }
        String this$m_className = this.m_className;
        String other$m_className = other.m_className;
        if (this$m_className == null ? other$m_className != null : !this$m_className.equals(other$m_className)) {
            return false;
        }
        String this$m_methodName = this.m_methodName;
        String other$m_methodName = other.m_methodName;
        if (this$m_methodName == null ? other$m_methodName != null : !this$m_methodName.equals(other$m_methodName)) {
            return false;
        }
        Map<String, String> this$m_tags = this.m_tags;
        Map<String, String> other$m_tags = other.m_tags;
        if (this$m_tags == null ? other$m_tags != null : !((Object)this$m_tags).equals(other$m_tags)) {
            return false;
        }
        List<ReportedMetric.Sample> this$m_samples = this.m_samples;
        List<ReportedMetric.Sample> other$m_samples = other.m_samples;
        return !(this$m_samples == null ? other$m_samples != null : !((Object)this$m_samples).equals(other$m_samples));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportedMetricImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instant $m_time = this.m_time;
        result = result * 59 + ($m_time == null ? 43 : ((Object)$m_time).hashCode());
        String $m_className = this.m_className;
        result = result * 59 + ($m_className == null ? 43 : $m_className.hashCode());
        String $m_methodName = this.m_methodName;
        result = result * 59 + ($m_methodName == null ? 43 : $m_methodName.hashCode());
        Map<String, String> $m_tags = this.m_tags;
        result = result * 59 + ($m_tags == null ? 43 : ((Object)$m_tags).hashCode());
        List<ReportedMetric.Sample> $m_samples = this.m_samples;
        result = result * 59 + ($m_samples == null ? 43 : ((Object)$m_samples).hashCode());
        return result;
    }

    public class SampleImpl
    implements ReportedMetric.Sample {
        private final String m_fieldName;
        private final MetricValue m_value;
        private final Instant m_time;

        public SampleImpl(String fieldName, MetricValue value) {
            this.m_fieldName = fieldName;
            this.m_value = value;
            this.m_time = null;
        }

        public SampleImpl(String fieldName, MetricValue value, Instant time) {
            this.m_fieldName = fieldName;
            this.m_value = value;
            this.m_time = time;
        }

        @Override
        public String getFieldName() {
            return this.m_fieldName;
        }

        @Override
        public MetricValue getValue() {
            return this.m_value;
        }

        @Override
        public Instant getTime() {
            if (this.m_time != null) {
                return this.m_time;
            }
            return ReportedMetricImpl.this.m_time;
        }

        public String toString() {
            return "ReportedMetricImpl.SampleImpl(m_fieldName=" + this.m_fieldName + ", m_value=" + this.m_value + ", m_time=" + this.m_time + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SampleImpl)) {
                return false;
            }
            SampleImpl other = (SampleImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$m_fieldName = this.m_fieldName;
            String other$m_fieldName = other.m_fieldName;
            if (this$m_fieldName == null ? other$m_fieldName != null : !this$m_fieldName.equals(other$m_fieldName)) {
                return false;
            }
            MetricValue this$m_value = this.m_value;
            MetricValue other$m_value = other.m_value;
            if (this$m_value == null ? other$m_value != null : !((Object)this$m_value).equals(other$m_value)) {
                return false;
            }
            Instant this$m_time = this.m_time;
            Instant other$m_time = other.m_time;
            return !(this$m_time == null ? other$m_time != null : !((Object)this$m_time).equals(other$m_time));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SampleImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $m_fieldName = this.m_fieldName;
            result = result * 59 + ($m_fieldName == null ? 43 : $m_fieldName.hashCode());
            MetricValue $m_value = this.m_value;
            result = result * 59 + ($m_value == null ? 43 : ((Object)$m_value).hashCode());
            Instant $m_time = this.m_time;
            result = result * 59 + ($m_time == null ? 43 : ((Object)$m_time).hashCode());
            return result;
        }
    }
}

