/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender;

import io.logz.sender.LogsQueue;
import io.logz.sender.LogzioSender;
import io.logz.sender.SenderStatusReporter;
import io.logz.sender.exceptions.LogzioParameterErrorException;
import io.logz.sender.org.ikasan.bigqueue.BigQueueImpl;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DiskQueue
implements LogsQueue {
    private final BigQueueImpl logsQueue;
    private final File queueDirectory;
    private final boolean dontCheckEnoughDiskSpace;
    private final int fsPercentThreshold;
    private final SenderStatusReporter reporter;
    private volatile boolean isEnoughSpace;

    private DiskQueue(File queueDir, boolean dontCheckEnoughDiskSpace, int fsPercentThreshold, int gcPersistedQueueFilesIntervalSeconds, SenderStatusReporter reporter, int checkDiskSpaceInterval, ScheduledExecutorService diskSpaceTasks) throws LogzioParameterErrorException, IOException {
        this.reporter = reporter;
        this.queueDirectory = queueDir;
        this.validateParameters();
        String dir = queueDir.getAbsoluteFile().getParent();
        String queueNameDir = queueDir.getName();
        if (dir == null || queueNameDir.isEmpty()) {
            throw new LogzioParameterErrorException("queueDir", " value is empty: " + queueDir.getAbsolutePath());
        }
        this.logsQueue = new BigQueueImpl(dir, queueNameDir);
        this.dontCheckEnoughDiskSpace = dontCheckEnoughDiskSpace;
        this.fsPercentThreshold = fsPercentThreshold;
        this.isEnoughSpace = true;
        diskSpaceTasks.scheduleWithFixedDelay(this::gcBigQueue, 0L, gcPersistedQueueFilesIntervalSeconds, TimeUnit.SECONDS);
        diskSpaceTasks.scheduleWithFixedDelay(this::validateEnoughSpace, 0L, checkDiskSpaceInterval, TimeUnit.MILLISECONDS);
    }

    private void validateParameters() throws LogzioParameterErrorException {
        if (this.queueDirectory == null) {
            throw new LogzioParameterErrorException("bufferDir", "value is null.");
        }
        if (this.reporter == null) {
            throw new LogzioParameterErrorException("reporter", "value is null.");
        }
    }

    @Override
    public void enqueue(byte[] log) {
        if (this.isEnoughSpace) {
            try {
                this.logsQueue.enqueue(log);
            }
            catch (IOException e) {
                this.reporter.error("Encountered an error while enqueue", e);
            }
        }
    }

    @Override
    public byte[] dequeue() {
        byte[] logs = null;
        try {
            logs = this.logsQueue.dequeue();
        }
        catch (IOException e) {
            this.reporter.error("Encountered an error while dequeue", e);
        }
        return logs;
    }

    @Override
    public boolean isEmpty() {
        return this.logsQueue.isEmpty();
    }

    private void validateEnoughSpace() {
        try {
            if (this.dontCheckEnoughDiskSpace) {
                return;
            }
            int actualUsedFsPercent = 100 - (int)((double)this.queueDirectory.getUsableSpace() / (double)this.queueDirectory.getTotalSpace() * 100.0);
            if (actualUsedFsPercent >= this.fsPercentThreshold) {
                if (this.isEnoughSpace) {
                    this.reporter.warning(String.format("Logz.io: Dropping logs, as FS used space on %s is %d percent, and the drop threshold is %d percent", this.queueDirectory.getAbsolutePath(), actualUsedFsPercent, this.fsPercentThreshold));
                }
                this.isEnoughSpace = false;
            } else {
                this.isEnoughSpace = true;
            }
        }
        catch (Throwable e) {
            this.reporter.error("Uncaught error from validateEnoughSpace()", e);
        }
    }

    private void gcBigQueue() {
        try {
            this.logsQueue.gc();
        }
        catch (Throwable e) {
            this.reporter.error("Uncaught error from BigQueue.gc()", e);
        }
    }

    @Override
    public void clear() throws IOException {
        this.logsQueue.removeAll();
    }

    @Override
    public void close() {
        this.gcBigQueue();
    }

    public static Builder builder(LogzioSender.Builder context, ScheduledExecutorService diskSpaceTasks) {
        return new Builder(context, diskSpaceTasks);
    }

    public static class Builder {
        private boolean dontCheckEnoughDiskSpace = false;
        private int fsPercentThreshold = 98;
        private int gcPersistedQueueFilesIntervalSeconds = 30;
        private int checkDiskSpaceInterval = 1000;
        private File queueDir;
        private SenderStatusReporter reporter;
        private ScheduledExecutorService diskSpaceTasks;
        private LogzioSender.Builder context;

        Builder(LogzioSender.Builder context, ScheduledExecutorService diskSpaceTasks) {
            this.context = context;
            this.diskSpaceTasks = diskSpaceTasks;
        }

        public Builder setFsPercentThreshold(int fsPercentThreshold) {
            this.fsPercentThreshold = fsPercentThreshold;
            if (fsPercentThreshold == -1) {
                this.dontCheckEnoughDiskSpace = true;
            }
            return this;
        }

        public Builder setGcPersistedQueueFilesIntervalSeconds(int gcPersistedQueueFilesIntervalSeconds) {
            this.gcPersistedQueueFilesIntervalSeconds = gcPersistedQueueFilesIntervalSeconds;
            return this;
        }

        public Builder setCheckDiskSpaceInterval(int checkDiskSpaceInterval) {
            this.checkDiskSpaceInterval = checkDiskSpaceInterval;
            return this;
        }

        public Builder setQueueDir(File queueDir) {
            this.queueDir = queueDir;
            return this;
        }

        Builder setReporter(SenderStatusReporter reporter) {
            this.reporter = reporter;
            return this;
        }

        Builder setDiskSpaceTasks(ScheduledExecutorService diskSpaceTasks) {
            this.diskSpaceTasks = diskSpaceTasks;
            return this;
        }

        public LogzioSender.Builder endDiskQueue() {
            this.context.setDiskQueueBuilder(this);
            return this.context;
        }

        DiskQueue build() throws LogzioParameterErrorException, IOException {
            return new DiskQueue(this.queueDir, this.dontCheckEnoughDiskSpace, this.fsPercentThreshold, this.gcPersistedQueueFilesIntervalSeconds, this.reporter, this.checkDiskSpaceInterval, this.diskSpaceTasks);
        }
    }
}

