package io.lsn.pipeline;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;

import java.util.List;

public class Pipeline {

    private static final Logger logger = LoggerFactory.getLogger(Pipeline.class);

    private List<Pipe> pipes;

    public Pipeline(List<Pipe> pipes) {
        this.pipes = pipes;
    }

    /**
     * process pipeline work
     *
     * @param payload
     * @return
     */
    public Payload process(Payload payload) {
        Payload prev = payload;
        for (Pipe pipe : pipes) {
            if (!pipe.proceed(payload)) {
                continue;
            }
            try {
                prev = pipe.execute(payload);
            } catch (StopPipelineException e) {
                logger.info(e.getMessage(), e);
                break;
            }
        }

        return prev;
    }
}
