/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.pipeline;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import io.lsn.pipeline.Payload;
import io.lsn.pipeline.Pipe;
import io.lsn.pipeline.StopPipelineException;
import java.util.List;

public class Pipeline {
    private static final Logger logger = LoggerFactory.getLogger(Pipeline.class);
    private List<Pipe> pipes;

    public Pipeline(List<Pipe> pipes) {
        this.pipes = pipes;
    }

    public Payload process(Payload payload) {
        Payload prev = payload;
        for (Pipe pipe : this.pipes) {
            if (!pipe.proceed(payload)) continue;
            try {
                prev = pipe.execute(payload);
            }
            catch (StopPipelineException e) {
                logger.info(e.getMessage(), (Throwable)e);
                break;
            }
        }
        return prev;
    }
}

