package io.lsn.spring.mf.configuration;

import io.lsn.spring.mf.configuration.domain.VatProperties;
import io.lsn.spring.mf.configuration.domain.WlRegistryProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "io.lsn.spring.mf")
public class MFProperties {

    private VatProperties vat;

    private WlRegistryProperties wl;

    public VatProperties getVat() {
        return vat;
    }

    public MFProperties setVat(VatProperties vat) {
        this.vat = vat;
        return this;
    }

    public WlRegistryProperties getWl() {
        if (wl == null) {
            wl = new WlRegistryProperties();
        }
        return wl;
    }

    public MFProperties setWl(WlRegistryProperties wl) {
        this.wl = wl;
        return this;
    }
}
