package io.lsn.spring.mf.domain.oauth2.entity;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.time.LocalDateTime;

public class OAuth2Response {

    @JsonProperty("access_token")
    private String accessToken;

    @JsonProperty("token_type")
    private String tokenType;

    @JsonProperty("expires_in")
    private Long expiresIn;

    @JsonProperty("scope")
    private String scope;

    @JsonProperty("expires_date")
    private LocalDateTime expiresDate;

    public String getAccessToken() {
        return accessToken;
    }

    public OAuth2Response setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public String getTokenType() {
        return tokenType;
    }

    public OAuth2Response setTokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public Long getExpiresIn() {
        return expiresIn;
    }

    public OAuth2Response setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
        this.expiresDate = LocalDateTime.now().plusSeconds(expiresIn);
        return this;
    }

    public String getScope() {
        return scope;
    }

    public OAuth2Response setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public LocalDateTime getExpiresDate() {
        return expiresDate;
    }

    public OAuth2Response setExpiresDate(LocalDateTime expiresDate) {
        this.expiresDate = expiresDate;
        return this;
    }
}
