package io.lsn.spring.mf.domain.oauth2.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.lsn.spring.mf.configuration.MFProperties;
import io.lsn.spring.mf.configuration.domain.WlBrokerProperties;
import io.lsn.spring.mf.domain.oauth2.entity.OAuth2Response;
import io.lsn.spring.utilities.cache.RedissonConfigurationHelper;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.stereotype.Service;

@Service
public class TokenService {

    private RedissonClient redissonClient;
    private RBucket<OAuth2Response> bucket;

    public TokenService(RedisProperties redisProperties,
                        ObjectMapper mapper,
                        MFProperties mfProperties) {
        WlBrokerProperties brokerProperties = mfProperties.getWl().getBroker();
        if (Boolean.TRUE.equals(brokerProperties.isEnabled())) {
            Config config = RedissonConfigurationHelper.getDefaultConfiguration(redisProperties, brokerProperties.getRedisDatabase());
            config.setCodec(new JsonJacksonCodec(mapper));
            this.redissonClient = Redisson.create(config);
            this.bucket = this.redissonClient.getBucket("tokenData");
        }
    }

    public void putIntoBucket(OAuth2Response tokenData) {
        bucket.set(tokenData);
    }

    public OAuth2Response getFromBucket() {
        return bucket.get();
    }

    public void updateBucketContent(OAuth2Response tokenData) {
        bucket.set(tokenData);
    }

}

