package io.lsn.spring.mf.domain.vat;

import io.lsn.spring.mf.configuration.MfCacheConfiguration;
import io.lsn.spring.mf.domain.vat.entity.VatResult;
import io.lsn.spring.mf.domain.vat.exception.VatConnectionException;
import io.lsn.spring.utilities.configuration.condition.ConditionalOnConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnConfiguration(name = "io.lsn.spring.mf.vat", type = ConditionalOnConfiguration.Type.SERVICE)
public class CacheableVatService {

    @Autowired
    private VatService vatService;

    @Cacheable(key = "'checkVat:' + #nip", cacheNames = MfCacheConfiguration.CACHE_MF)
    public VatResult checkVat(String nip) throws VatConnectionException {
        return vatService.checkVat(nip);
    }

    @Cacheable(key = "'activeVat:' + #nip", cacheNames = MfCacheConfiguration.CACHE_MF)
    public Boolean isActiveVat(String nip) throws VatConnectionException {
        return vatService.isActiveVat(nip);
    }
}
