package io.lsn.spring.mf.domain.vat;

import io.lsn.spring.mf.domain.vat.entity.VatResult;
import io.lsn.spring.mf.domain.vat.entity.VatResultValue;
import io.lsn.spring.mf.domain.vat.exception.VatConnectionException;
import io.lsn.spring.mf.domain.vat.helper.VatResultMapper;
import io.lsn.spring.mf.transport.soap.client.vat.VATServiceFactory;
import io.lsn.spring.utilities.configuration.condition.ConditionalOnConfiguration;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnConfiguration(name = "io.lsn.spring.mf.vat", type = ConditionalOnConfiguration.Type.SERVICE)
public class VatService {

    private VATServiceFactory vatServiceFactory;

    public VatService(VATServiceFactory vatServiceFactory) {
        this.vatServiceFactory = vatServiceFactory;
    }

    /**
     * check vat status of given entity
     *
     * @param nip tax id
     * @return
     */
    public VatResult checkVat(String nip) throws VatConnectionException {
        return VatResultMapper.of(vatServiceFactory.checkVat(nip));
    }

    /**
     * return plain information if provided tax id belongs to party that is active vat entity
     *
     * @param nip tax id
     * @return
     */
    public Boolean isActiveVat(String nip) throws VatConnectionException {
        return VatResultValue.ACTIVE.equals(checkVat(nip).getValue());
    }


}
