package io.lsn.spring.mf.domain.vat.entity.rabbit;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.lsn.spring.mf.domain.wl.domain.Response;

import java.util.Map;

public class VatTransportResponse {

    private String requestId;
    private String ticketId;
    private boolean success = false;
    private boolean fromCache = false;
    private String nip;
    private String iban;
    private String companyCode;
    private Response response;
    private Map<String, String> error;
    private String ip;

    public String getRequestId() {
        return requestId;
    }

    public VatTransportResponse setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getTicketId() {
        return ticketId;
    }

    public VatTransportResponse setTicketId(String ticketId) {
        this.ticketId = ticketId;
        return this;
    }

    public boolean isSuccess() {
        return success;
    }

    public VatTransportResponse setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public boolean isFromCache() {
        return fromCache;
    }

    public VatTransportResponse setFromCache(boolean fromCache) {
        this.fromCache = fromCache;
        return this;
    }

    public String getNip() {
        return nip;
    }

    public VatTransportResponse setNip(String nip) {
        this.nip = nip;
        return this;
    }

    public String getIban() {
        return iban;
    }

    public VatTransportResponse setIban(String iban) {
        this.iban = iban;
        return this;
    }

    public Response getResponse() {
        return response;
    }

    public VatTransportResponse setResponse(Response response) {
        this.response = response;
        return this;
    }

    public Map<String, String> getError() {
        return error;
    }

    public VatTransportResponse setError(Map<String, String> error) {
        this.error = error;
        return this;
    }

    public String getIp() {
        return ip;
    }

    public VatTransportResponse setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public VatTransportResponse setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
        return this;
    }

    @JsonIgnore
    public String getErrorCode() {
        if (error != null) {
            return String.format("%s %s", error.get("code"), error.get("message"));
        }
        return null;
    }
}
