package io.lsn.spring.mf.domain.wl;


import io.lsn.spring.mf.configuration.MFProperties;
import io.lsn.spring.mf.configuration.MfCacheConfiguration;
import io.lsn.spring.mf.domain.wl.domain.Response;
import io.lsn.spring.mf.domain.wl.domain.VerificationException;
import io.lsn.spring.utilities.configuration.condition.ConditionalOnConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnConfiguration(name = "io.lsn.spring.wl.api", type = ConditionalOnConfiguration.Type.SERVICE)
public class CacheableWlRegistryService {

    @Autowired
    private MFProperties properties;

    @Autowired
    private WlRegistryService service;
    
    @Cacheable(
            key = "'searchNip:' + #taxId + ',iban:' + #iban",
            cacheNames = MfCacheConfiguration.CACHE_WL_API
    )
    public Response searchNip(String companyCode, String taxId, String iban) throws VerificationException {
        if (Boolean.TRUE.equals(properties.getWl().getBroker().isEnabled())) {
            return service.searchNipViaBroker(companyCode, taxId, iban);
        } else {
            return service.searchNip(taxId, iban);
        }
    }


}
