package io.lsn.spring.mf.domain.wl.domain;

public enum VatStatusFlag {
    ACTIVE("Czynny"),
    EXEMPT("Zwolniony"),
    NON_REGISTERED("Podmiot niezarejestrowany do VAT"),
    NOT_FOUND("");

    private String value;

    VatStatusFlag(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static VatStatusFlag byValue(String value) {
        for (VatStatusFlag e : VatStatusFlag.values()) {
            if (e.getValue().equals(value)) {
                return e;
            }
        }
        return null;
    }

    }
