package io.lsn.spring.mf.domain.wl.domain;

import java.util.HashMap;
import java.util.Map;

public class VerificationException extends Exception {

    private String code;

    private String message;

    public VerificationException(String code) {
        this.code = code;
    }

    public VerificationException(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public Map<String, String> asMap() {
        Map<String, String> result = new HashMap<>();
        result.put("code", code);
        result.put("message", message);
        return result;
    }

    public String getCode() {
        return code;
    }

    public VerificationException setCode(String code) {
        this.code = code;
        return this;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public VerificationException setMessage(String message) {
        this.message = message;
        return this;
    }
}
