package io.lsn.spring.mf.domain.wl.domain.external;

import java.time.LocalDate;
import java.util.List;

public class Entity {

    // Firma (nazwa) lub imię i nazwisko
    private String name;

    private String nip;

    /**
     * Czynny
     * Zwolniony
     * Podmiot niezarejestrowany do VAT
     */
    private String statusVat;

    private String regon;

    private String pesel;

    private String krs;

    /**
     * Adres siedziby
     */
    private String residenceAddress;


    /**
     * Adres stałego miejsca prowadzenia działalności lub adres miejsca zamieszkania w przypadku braku adresu stałego miejsca prowadzenia działalności
     */
    private String workingAddress;


    /**
     * Imiona i nazwiska osób wchodzących w skład organu uprawnionego do reprezentowania
     */
    private List<Person> representatives;


    /**
     * Imiona i nazwiska prokurentów oraz ich numery NIP i/lub PESEL
     */
    private List<Person> authorizedClerks;


    /**
     * Imiona i nazwiska lub firmę (nazwa) wspólnika oraz jego numeryNIP i/lub PESEL
     */
    private List<EntityPerson> partners;


    /**
     * Data rejestracji jako podatnika VAT format: date
     */
    private LocalDate registrationLegalDate;


    /**
     * Data odmowy rejestracji jako podatnika VAT format: date
     */
    private LocalDate registrationDenialDate;


    /**
     * Podstawa prawna odmowy rejestracji
     */
    private String registrationDenialBasis;


    /**
     * Data przywrócenia jako podatnika VAT format: date
     */
    private LocalDate restorationDate;


    /**
     * Podstawa prawna przywrócenia jako podatnika VAT
     */
    private String restorationBasis;


    /**
     * Data wykreślenia odmowy rejestracji jako podatnika VAT format: date
     */
    private LocalDate removalDate;


    /**
     * Podstawa prawna wykreślenia odmowy rejestracji jako podatnika VAT
     */
    private String removalBasis;


    /**
     * lista rachunków bankowych
     */
    private List<String> accountNumbers;


    /**
     * Podmiot posiada maski kont wirtualnych
     */
    private Boolean hasVirtualAccounts;


    public String getName() {
        return name;
    }

    public Entity setName(String name) {
        this.name = name;
        return this;
    }

    public String getNip() {
        return nip;
    }

    public Entity setNip(String nip) {
        this.nip = nip;
        return this;
    }

    public String getStatusVat() {
        return statusVat;
    }

    public Entity setStatusVat(String statusVat) {
        this.statusVat = statusVat;
        return this;
    }

    public String getRegon() {
        return regon;
    }

    public Entity setRegon(String regon) {
        this.regon = regon;
        return this;
    }

    public String getPesel() {
        return pesel;
    }

    public Entity setPesel(String pesel) {
        this.pesel = pesel;
        return this;
    }

    public String getKrs() {
        return krs;
    }

    public Entity setKrs(String krs) {
        this.krs = krs;
        return this;
    }

    public String getResidenceAddress() {
        return residenceAddress;
    }

    public Entity setResidenceAddress(String residenceAddress) {
        this.residenceAddress = residenceAddress;
        return this;
    }

    public String getWorkingAddress() {
        return workingAddress;
    }

    public Entity setWorkingAddress(String workingAddress) {
        this.workingAddress = workingAddress;
        return this;
    }

    public List<Person> getRepresentatives() {
        return representatives;
    }

    public Entity setRepresentatives(List<Person> representatives) {
        this.representatives = representatives;
        return this;
    }

    public List<Person> getAuthorizedClerks() {
        return authorizedClerks;
    }

    public Entity setAuthorizedClerks(List<Person> authorizedClerks) {
        this.authorizedClerks = authorizedClerks;
        return this;
    }

    public List<EntityPerson> getPartners() {
        return partners;
    }

    public Entity setPartners(List<EntityPerson> partners) {
        this.partners = partners;
        return this;
    }

    public LocalDate getRegistrationLegalDate() {
        return registrationLegalDate;
    }

    public Entity setRegistrationLegalDate(LocalDate registrationLegalDate) {
        this.registrationLegalDate = registrationLegalDate;
        return this;
    }

    public LocalDate getRegistrationDenialDate() {
        return registrationDenialDate;
    }

    public Entity setRegistrationDenialDate(LocalDate registrationDenialDate) {
        this.registrationDenialDate = registrationDenialDate;
        return this;
    }

    public String getRegistrationDenialBasis() {
        return registrationDenialBasis;
    }

    public Entity setRegistrationDenialBasis(String registrationDenialBasis) {
        this.registrationDenialBasis = registrationDenialBasis;
        return this;
    }

    public LocalDate getRestorationDate() {
        return restorationDate;
    }

    public Entity setRestorationDate(LocalDate restorationDate) {
        this.restorationDate = restorationDate;
        return this;
    }

    public String getRestorationBasis() {
        return restorationBasis;
    }

    public Entity setRestorationBasis(String restorationBasis) {
        this.restorationBasis = restorationBasis;
        return this;
    }

    public LocalDate getRemovalDate() {
        return removalDate;
    }

    public Entity setRemovalDate(LocalDate removalDate) {
        this.removalDate = removalDate;
        return this;
    }

    public String getRemovalBasis() {
        return removalBasis;
    }

    public Entity setRemovalBasis(String removalBasis) {
        this.removalBasis = removalBasis;
        return this;
    }

    public List<String> getAccountNumbers() {
        return accountNumbers;
    }

    public Entity setAccountNumbers(List<String> accountNumbers) {
        this.accountNumbers = accountNumbers;
        return this;
    }

    public Boolean getHasVirtualAccounts() {
        return hasVirtualAccounts;
    }

    public Entity setHasVirtualAccounts(Boolean hasVirtualAccounts) {
        this.hasVirtualAccounts = hasVirtualAccounts;
        return this;
    }
}
