package io.lsn.spring.mf.transport.soap.handler;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import io.lsn.spring.mf.transport.soap.handler.worker.LogWorker;
import io.lsn.spring.mf.transport.soap.handler.worker.Worker;
import org.springframework.stereotype.Component;

import javax.xml.namespace.QName;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Patryk Szlagowski <patryksz@lnsova.pl>
 */
@Component
public class SoapLoggingInterceptor implements SOAPHandler<SOAPMessageContext> {

    private static final Logger logger = LoggerFactory.getLogger(SoapLoggingInterceptor.class);

    private LogWorker logWorker;

    @Override
    public Set<QName> getHeaders() {
        return new HashSet<>();
    }

    @Override
    public boolean handleMessage(SOAPMessageContext context) {
        this.log(context);
        return true;
    }

    @Override
    public boolean handleFault(SOAPMessageContext context) {
        this.log(context);
        return true;
    }

    @Override
    public void close(javax.xml.ws.handler.MessageContext context) {
        // empty method to match interface
    }

    private void log(SOAPMessageContext context) {
        try {
            this.getWorker().process(context);
        } catch (Exception e) {
            logger.info(e.getMessage(), e);
        }
    }

    private Worker getWorker() {
        if (this.logWorker == null) {
            this.logWorker = new LogWorker();
        }

        return this.logWorker;
    }
}
