package io.lsn.spring.mf.transport.soap.handler.worker;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;

import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import java.io.ByteArrayOutputStream;

/**
 * @author Patryk Szlagowski <patryksz@lnsova.pl>
 */
public class LogWorker implements Worker {

    private static final Logger logger = LoggerFactory.getLogger(LogWorker.class);

    private static final int MAX_LOG_SIZE = 50000;

    @Override
    public void process(SOAPMessageContext message) {
        this.log(message.getMessage());
    }

    @SuppressWarnings("Duplicates")
    private void log(SOAPMessage message) {
        try {
            String m = soapMsgToString(message);
            if (m != null) {
                if (m.length() > MAX_LOG_SIZE) {
                    logger.info("SOAP message was too long and has been removed. Partial is here:" + m.substring(0, 1000));
                } else {
                    logger.info(m);
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /**
     * msg soapowa jako String
     *
     * @param msg
     * @return
     * @throws Exception
     */
    @SuppressWarnings("Duplicates")
    private String soapMsgToString(SOAPMessage msg) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            msg.writeTo(stream);
            return new String(stream.toByteArray(), "utf-8");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

}
