/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.mf.domain.oauth2;

import io.lsn.spring.mf.configuration.MFProperties;
import io.lsn.spring.mf.configuration.domain.WlBrokerProperties;
import io.lsn.spring.mf.domain.oauth2.entity.OAuth2Response;
import io.lsn.spring.mf.domain.oauth2.handler.RestClientErrorHandler;
import io.lsn.spring.mf.domain.oauth2.service.TokenService;
import io.lsn.spring.rest.helper.LoggingInterceptor;
import java.time.LocalDateTime;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Order(value=-2147483648)
public class OAuth2Service {
    private WlBrokerProperties properties;
    private TokenService tokenService;
    private RestTemplateBuilder restTemplateBuilder;

    public OAuth2Service(MFProperties properties, TokenService tokenService, RestTemplateBuilder restTemplateBuilder) {
        this.properties = properties.getWl().getBroker();
        this.tokenService = tokenService;
        this.restTemplateBuilder = restTemplateBuilder;
    }

    public String getAuthorizationHeader() {
        OAuth2Response tokenData = this.tokenService.getFromBucket();
        if (tokenData == null || tokenData.getAccessToken() == null || LocalDateTime.now().isAfter(tokenData.getExpiresDate())) {
            return this.creteNewSession();
        }
        return tokenData.getAccessToken();
    }

    private String creteNewSession() {
        String url = String.format("%s/oauth/token", this.properties.getUrl());
        String uri = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("grant_type", new Object[]{"password"}).queryParam("username", new Object[]{this.properties.getUsername()}).queryParam("password", new Object[]{this.properties.getPassword()}).toUriString();
        OAuth2Response newTokenData = (OAuth2Response)this.buildRestTemplate().exchange(uri, HttpMethod.POST, this.buildHttpRequest(this.properties.getClientId(), this.properties.getClientSecret()), OAuth2Response.class, new Object[0]).getBody();
        return this.storeTokenData(newTokenData);
    }

    private String storeTokenData(OAuth2Response newTokenData) {
        this.tokenService.putIntoBucket(newTokenData);
        return newTokenData.getAccessToken();
    }

    private RestTemplate buildRestTemplate() {
        return this.restTemplateBuilder.additionalMessageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()}).additionalInterceptors(new ClientHttpRequestInterceptor[]{new LoggingInterceptor()}).additionalCustomizers(new RestTemplateCustomizer[]{restTemplate -> {
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            factory.setOutputStreaming(false);
            restTemplate.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)factory));
        }}).errorHandler((ResponseErrorHandler)new RestClientErrorHandler()).build();
    }

    private HttpEntity<MultiValueMap<String, String>> buildHttpRequest(String username, String password) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBasicAuth(username, password);
        return new HttpEntity((MultiValueMap)headers);
    }
}

