/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.mf.domain.vat;

import io.lsn.spring.mf.domain.vat.VatService;
import io.lsn.spring.mf.domain.vat.entity.VatResult;
import io.lsn.spring.mf.domain.vat.exception.VatConnectionException;
import io.lsn.spring.utilities.configuration.condition.ConditionalOnConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnConfiguration(name="io.lsn.spring.mf.vat", type=ConditionalOnConfiguration.Type.SERVICE)
public class CacheableVatService {
    @Autowired
    private VatService vatService;

    @Cacheable(key="'checkVat:' + #nip", cacheNames={"cache_mf"})
    public VatResult checkVat(String nip) throws VatConnectionException {
        return this.vatService.checkVat(nip);
    }

    @Cacheable(key="'activeVat:' + #nip", cacheNames={"cache_mf"})
    public Boolean isActiveVat(String nip) throws VatConnectionException {
        return this.vatService.isActiveVat(nip);
    }
}

