/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.mf.domain.vat;

import io.lsn.spring.mf.domain.vat.entity.VatResult;
import io.lsn.spring.mf.domain.vat.entity.VatResultValue;
import io.lsn.spring.mf.domain.vat.exception.VatConnectionException;
import io.lsn.spring.mf.domain.vat.helper.VatResultMapper;
import io.lsn.spring.mf.transport.soap.client.vat.VATServiceFactory;
import io.lsn.spring.utilities.configuration.condition.ConditionalOnConfiguration;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnConfiguration(name="io.lsn.spring.mf.vat", type=ConditionalOnConfiguration.Type.SERVICE)
public class VatService {
    private VATServiceFactory vatServiceFactory;

    public VatService(VATServiceFactory vatServiceFactory) {
        this.vatServiceFactory = vatServiceFactory;
    }

    public VatResult checkVat(String nip) throws VatConnectionException {
        return VatResultMapper.of(this.vatServiceFactory.checkVat(nip));
    }

    public Boolean isActiveVat(String nip) throws VatConnectionException {
        return VatResultValue.ACTIVE.equals((Object)this.checkVat(nip).getValue());
    }
}

