/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.mf.domain.wl;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import io.lsn.spring.mf.configuration.MFProperties;
import io.lsn.spring.mf.configuration.domain.WlRegistryProperties;
import io.lsn.spring.mf.domain.oauth2.OAuth2Service;
import io.lsn.spring.mf.domain.oauth2.handler.RestClientErrorHandler;
import io.lsn.spring.mf.domain.vat.entity.rabbit.VatTransportResponse;
import io.lsn.spring.mf.domain.wl.domain.Response;
import io.lsn.spring.mf.domain.wl.domain.VatStatusFlag;
import io.lsn.spring.mf.domain.wl.domain.VerificationException;
import io.lsn.spring.mf.domain.wl.domain.external.EntityResponse;
import io.lsn.spring.mf.domain.wl.domain.external.ResultException;
import io.lsn.spring.rest.RestClient;
import io.lsn.spring.rest.helper.LoggingInterceptor;
import io.lsn.spring.utilities.configuration.condition.ConditionalOnConfiguration;
import io.lsn.spring.utilities.json.mapper.JsonMapper;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@ConditionalOnConfiguration(name="io.lsn.spring.wl.api", type=ConditionalOnConfiguration.Type.SERVICE)
public class WlRegistryService {
    private static final Logger logger = LoggerFactory.getLogger(WlRegistryService.class);
    private static final String HEADER_NAME_AUTHORIZATION = "Authorization";
    private RestClient restClient;
    private WlRegistryProperties wlRegistryProperties;
    private OAuth2Service oAuth2Service;
    private RestTemplateBuilder restTemplateBuilder;

    public WlRegistryService(RestClient restClient, MFProperties mfProperties, OAuth2Service oAuth2Service, RestTemplateBuilder restTemplateBuilder) {
        this.restClient = restClient;
        this.wlRegistryProperties = mfProperties.getWl();
        this.oAuth2Service = oAuth2Service;
        this.restTemplateBuilder = restTemplateBuilder;
    }

    public Response searchNip(String taxId, String iban) throws VerificationException {
        try {
            ResponseEntity result = this.restClient.get(this.wlRegistryProperties.getApiUrl() + "/search/nip/" + taxId + "?date=" + LocalDate.now().toString(), EntityResponse.class);
            String ibanNoPrefix = iban.replaceAll("[^\\d]", "");
            if (result.getBody() == null) {
                throw new VerificationException(String.valueOf(result.getStatusCode()));
            }
            if (((EntityResponse)result.getBody()).getException() != null) {
                throw new VerificationException(((EntityResponse)result.getBody()).getException().getCode(), ((EntityResponse)result.getBody()).getException().getMessage());
            }
            Response response = new Response().setResponseId(((EntityResponse)result.getBody()).getResult().getRequestId()).setVatStatusFlag(VatStatusFlag.NOT_FOUND);
            if (((EntityResponse)result.getBody()).getResult().getSubject() != null) {
                String address = ((EntityResponse)result.getBody()).getResult().getSubject().getWorkingAddress();
                if (StringUtils.isBlank((String)address)) {
                    address = ((EntityResponse)result.getBody()).getResult().getSubject().getResidenceAddress();
                }
                response.setName(((EntityResponse)result.getBody()).getResult().getSubject().getName()).setHasIban(((EntityResponse)result.getBody()).getResult().getSubject().getAccountNumbers().contains(ibanNoPrefix)).setAddress(address).setVatStatusFlag(VatStatusFlag.byValue(((EntityResponse)result.getBody()).getResult().getSubject().getStatusVat()));
            }
            return response;
        }
        catch (RuntimeException exception) {
            if (exception instanceof HttpClientErrorException && ((HttpClientErrorException)exception).getRawStatusCode() == 400) {
                HttpClientErrorException e = (HttpClientErrorException)exception;
                try {
                    ResultException r = (ResultException)JsonMapper.getInstance().getObjectMapper().readValue(e.getResponseBodyAsString(), ResultException.class);
                    throw new VerificationException(r.getCode(), r.getMessage());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new VerificationException("500", exception.getMessage());
        }
    }

    public Response searchNipViaBroker(String companyCode, String taxId, String iban) throws VerificationException {
        try {
            String url = String.format("%s/api/public/vat", this.wlRegistryProperties.getBroker().getUrl());
            String uri = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("companyCode", new Object[]{companyCode}).queryParam("taxId", new Object[]{taxId}).queryParam("iban", new Object[]{iban}).toUriString();
            ResponseEntity rest = this.buildRestTemplate().exchange(uri, HttpMethod.GET, this.buildHttpEntity(), VatTransportResponse.class, new Object[0]);
            VatTransportResponse vatResponse = (VatTransportResponse)rest.getBody();
            if (vatResponse.getErrorCode() != null) {
                throw new VerificationException(vatResponse.getError().get("code"), vatResponse.getError().get("message"));
            }
            return vatResponse.getResponse();
        }
        catch (Exception exception) {
            throw new VerificationException("500", exception.getMessage());
        }
    }

    protected HttpEntity<MultiValueMap<String, String>> buildHttpEntity() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String authorization = String.format("Bearer %s", this.oAuth2Service.getAuthorizationHeader());
        headers.put(HEADER_NAME_AUTHORIZATION, Collections.singletonList(authorization));
        return new HttpEntity((MultiValueMap)headers);
    }

    protected RestTemplate buildRestTemplate() {
        RestTemplateBuilder builder = this.restTemplateBuilder.additionalMessageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()}).interceptors(new ClientHttpRequestInterceptor[]{new LoggingInterceptor()}).additionalCustomizers(new RestTemplateCustomizer[]{restTemplate -> {
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            factory.setOutputStreaming(false);
            restTemplate.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)factory));
        }}).errorHandler((ResponseErrorHandler)new RestClientErrorHandler());
        return builder.build();
    }
}

