/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.mf.transport.soap.client.vat;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import io.lsn.spring.mf.configuration.MFProperties;
import io.lsn.spring.mf.domain.vat.exception.VatConnectionException;
import io.lsn.spring.mf.transport.soap.client.vat.TWynikWeryfikacjiVAT;
import io.lsn.spring.mf.transport.soap.client.vat.WeryfikacjaVAT_Service;
import io.lsn.spring.utilities.soap.factory.AbstractFactory;
import java.io.File;
import java.net.URL;
import org.springframework.stereotype.Component;

@Component
public class VATServiceFactory
extends AbstractFactory<WeryfikacjaVAT_Service> {
    private static final Logger logger = LoggerFactory.getLogger(VATServiceFactory.class);
    private MFProperties webserviceClientConfiguration;

    public VATServiceFactory(MFProperties webserviceClientConfiguration) {
        this.webserviceClientConfiguration = webserviceClientConfiguration;
    }

    public WeryfikacjaVAT_Service getInstance() throws VatConnectionException {
        try {
            if (this.instance == null) {
                String wsdlLocation = this.webserviceClientConfiguration.getVat().getWsdl();
                this.instance = new WeryfikacjaVAT_Service(wsdlLocation.startsWith("http") ? new URL(wsdlLocation) : new File(wsdlLocation).toURI().toURL());
            }
            return (WeryfikacjaVAT_Service)((Object)this.instance);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new VatConnectionException(e.getMessage());
        }
    }

    public TWynikWeryfikacjiVAT checkVat(String nip) throws VatConnectionException {
        return this.getInstance().getBasicHttpBindingWeryfikacjaVAT().sprawdzNIP(nip);
    }
}

