/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.mf.transport.soap.handler;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import io.lsn.spring.mf.transport.soap.handler.worker.LogWorker;
import io.lsn.spring.mf.transport.soap.handler.worker.Worker;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.springframework.stereotype.Component;

@Component
public class SoapLoggingInterceptor
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger logger = LoggerFactory.getLogger(SoapLoggingInterceptor.class);
    private LogWorker logWorker;

    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    public boolean handleMessage(SOAPMessageContext context) {
        this.log(context);
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        this.log(context);
        return true;
    }

    public void close(MessageContext context) {
    }

    private void log(SOAPMessageContext context) {
        try {
            this.getWorker().process(context);
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
    }

    private Worker getWorker() {
        if (this.logWorker == null) {
            this.logWorker = new LogWorker();
        }
        return this.logWorker;
    }
}

