/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.mf.transport.soap.handler.worker;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import io.lsn.spring.mf.transport.soap.handler.worker.Worker;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class LogWorker
implements Worker {
    private static final Logger logger = LoggerFactory.getLogger(LogWorker.class);
    private static final int MAX_LOG_SIZE = 50000;

    @Override
    public void process(SOAPMessageContext message) {
        this.log(message.getMessage());
    }

    private void log(SOAPMessage message) {
        try {
            String m = this.soapMsgToString(message);
            if (m != null) {
                if (m.length() > 50000) {
                    logger.info("SOAP message was too long and has been removed. Partial is here:" + m.substring(0, 1000));
                } else {
                    logger.info(m);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private String soapMsgToString(SOAPMessage msg) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)stream);
            return new String(stream.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

