/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.services.lambda.runtime.Context;
import io.lumigo.core.configuration.Configuration;
import io.lumigo.core.network.Reporter;
import io.lumigo.core.parsers.AwsParserFactory;
import io.lumigo.core.parsers.event.EventParserFactory;
import io.lumigo.core.utils.AwsUtils;
import io.lumigo.core.utils.JsonUtils;
import io.lumigo.core.utils.StringUtils;
import io.lumigo.models.HttpSpan;
import io.lumigo.models.Span;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.pmw.tinylog.Logger;

public class SpansContainer {
    private static final int MAX_STRING_SIZE = Configuration.getInstance().maxSpanFieldSize();
    private static final int MAX_REQUEST_SIZE = Configuration.getInstance().maxRequestSize();
    private static final int MAX_LAMBDA_TIME = 900000;
    private static final String AWS_EXECUTION_ENV = "AWS_EXECUTION_ENV";
    private static final String AWS_REGION = "AWS_REGION";
    private static final String AMZN_TRACE_ID = "_X_AMZN_TRACE_ID";
    private static final String FUNCTION_SPAN_TYPE = "function";
    private static final String HTTP_SPAN_TYPE = "http";
    private Span baseSpan;
    private Span startFunctionSpan;
    private Long rttDuration;
    private Span endFunctionSpan;
    private Reporter reporter;
    private List<HttpSpan> httpSpans = new LinkedList<HttpSpan>();
    private static final SpansContainer ourInstance = new SpansContainer();
    private String awsTracerId;

    public static SpansContainer getInstance() {
        return ourInstance;
    }

    public void clear() {
        this.baseSpan = null;
        this.startFunctionSpan = null;
        this.rttDuration = null;
        this.endFunctionSpan = null;
        this.reporter = null;
        this.httpSpans = new LinkedList<HttpSpan>();
    }

    private SpansContainer() {
    }

    public void init(Map<String, String> env, Reporter reporter, Context context, Object event) {
        this.clear();
        this.reporter = reporter;
        this.awsTracerId = env.get(AMZN_TRACE_ID);
        AwsUtils.TriggeredBy triggeredBy = AwsUtils.extractTriggeredByFromEvent(event);
        long startTime = System.currentTimeMillis();
        this.baseSpan = Span.builder().token(Configuration.getInstance().getLumigoToken()).id(context.getAwsRequestId()).started(startTime).name(context.getFunctionName()).runtime(env.get(AWS_EXECUTION_ENV)).region(env.get(AWS_REGION)).memoryAllocated(String.valueOf(context.getMemoryLimitInMB())).requestId(context.getAwsRequestId()).account(AwsUtils.extractAwsAccountFromArn(context.getInvokedFunctionArn())).maxFinishTime(startTime + (long)(context.getRemainingTimeInMillis() > 0 ? context.getRemainingTimeInMillis() : 900000)).transactionId(AwsUtils.extractAwsTraceTransactionId(this.awsTracerId)).info(Span.Info.builder().tracer(Span.Tracer.builder().version(Configuration.getInstance().getLumigoTracerVersion()).build()).traceId(Span.TraceId.builder().root(AwsUtils.extractAwsTraceRoot(this.awsTracerId)).build()).triggeredBy(triggeredBy != null ? triggeredBy.getTriggeredBy() : null).api(triggeredBy != null ? triggeredBy.getApi() : null).arn(triggeredBy != null ? triggeredBy.getArn() : null).httpMethod(triggeredBy != null ? triggeredBy.getHttpMethod() : null).resource(triggeredBy != null ? triggeredBy.getResource() : null).stage(triggeredBy != null ? triggeredBy.getStage() : null).messageId(triggeredBy != null ? triggeredBy.getMessageId() : null).messageIds(triggeredBy != null ? triggeredBy.getMessageIds() : null).approxEventCreationTime(triggeredBy != null ? triggeredBy.getApproxEventCreationTime() : 0L).logGroupName(context.getLogGroupName()).logStreamName(context.getLogStreamName()).build()).type(FUNCTION_SPAN_TYPE).readiness(AwsUtils.getFunctionReadiness().toString()).envs(Configuration.getInstance().isLumigoVerboseMode() ? JsonUtils.getObjectAsJsonString(env) : null).event(Configuration.getInstance().isLumigoVerboseMode() ? JsonUtils.getObjectAsJsonString(EventParserFactory.parseEvent(event)) : null).build();
    }

    public void start() {
        this.startFunctionSpan = this.baseSpan.toBuilder().id(this.baseSpan.getId() + "_started").ended(this.baseSpan.getStarted()).build();
        try {
            this.rttDuration = this.reporter.reportSpans(this.prepareToSend(this.startFunctionSpan, false), MAX_REQUEST_SIZE);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e, (String)"Failed to send start span");
        }
    }

    public void end(Object response) throws IOException {
        this.end(this.baseSpan.toBuilder().return_value(Configuration.getInstance().isLumigoVerboseMode() ? JsonUtils.getObjectAsJsonString(response) : null).build());
    }

    public void endWithException(Throwable e) throws IOException {
        this.end(this.baseSpan.toBuilder().error(Span.Error.builder().message(e.getMessage()).type(e.getClass().getName()).stacktrace(this.getStackTrace(e)).build()).build());
    }

    public void end() throws IOException {
        this.end(this.baseSpan);
    }

    private void end(Span endFunctionSpan) throws IOException {
        this.endFunctionSpan = endFunctionSpan.toBuilder().reporter_rtt(this.rttDuration).ended(System.currentTimeMillis()).id(this.baseSpan.getId()).build();
        this.reporter.reportSpans(this.prepareToSend(this.getAllCollectedSpans(), endFunctionSpan.getError() != null), MAX_REQUEST_SIZE);
    }

    public Span getStartFunctionSpan() {
        return this.startFunctionSpan;
    }

    public List<Object> getAllCollectedSpans() {
        LinkedList<Object> spans = new LinkedList<Object>();
        spans.add(this.endFunctionSpan);
        spans.addAll(this.httpSpans);
        return spans;
    }

    public Span getEndSpan() {
        return this.endFunctionSpan;
    }

    public List<HttpSpan> getHttpSpans() {
        return this.httpSpans;
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private HttpSpan createBaseHttpSpan(Long startTime) {
        return HttpSpan.builder().id(UUID.randomUUID().toString()).started(startTime).ended(System.currentTimeMillis()).transactionId(this.baseSpan.getTransactionId()).account(this.baseSpan.getAccount()).region(this.baseSpan.getRegion()).token(this.baseSpan.getToken()).type(HTTP_SPAN_TYPE).parentId(this.baseSpan.getRequestId()).info(HttpSpan.Info.builder().tracer(HttpSpan.Tracer.builder().version(this.baseSpan.getInfo().getTracer().getVersion()).build()).traceId(HttpSpan.TraceId.builder().root(this.baseSpan.getInfo().getTraceId().getRoot()).build()).build()).build();
    }

    public void addHttpSpan(Long startTime, HttpUriRequest request, HttpResponse response) {
        HttpSpan httpSpan = this.createBaseHttpSpan(startTime);
        httpSpan.getInfo().setHttpInfo(HttpSpan.HttpInfo.builder().host(request.getURI().getHost()).request(HttpSpan.HttpData.builder().headers(SpansContainer.callIfVerbose(() -> SpansContainer.extractHeaders(request.getAllHeaders()))).uri(SpansContainer.callIfVerbose(() -> request.getURI().toString())).method(request.getMethod()).body(SpansContainer.callIfVerbose(() -> SpansContainer.extractBodyFromRequest(request))).build()).response(HttpSpan.HttpData.builder().headers(SpansContainer.callIfVerbose(() -> SpansContainer.extractHeaders(response.getAllHeaders()))).body(SpansContainer.callIfVerbose(() -> SpansContainer.extractBodyFromResponse(response))).statusCode(response.getStatusLine().getStatusCode()).build()).build());
        this.httpSpans.add(httpSpan);
    }

    public void addHttpSpan(Long startTime, Request<?> request, Response<?> response) {
        HttpSpan httpSpan = this.createBaseHttpSpan(startTime);
        String spanId = null;
        for (Map.Entry header : response.getHttpResponse().getHeaders().entrySet()) {
            if (!"x-amzn-requestid".equalsIgnoreCase((String)header.getKey()) && !"x-amz-requestid".equalsIgnoreCase((String)header.getKey())) continue;
            spanId = (String)header.getValue();
        }
        if (spanId != null) {
            httpSpan.setId(spanId);
        }
        httpSpan.getInfo().setHttpInfo(HttpSpan.HttpInfo.builder().host(request.getEndpoint().getHost()).request(HttpSpan.HttpData.builder().headers(SpansContainer.callIfVerbose(() -> SpansContainer.extractHeaders(request.getHeaders()))).uri(SpansContainer.callIfVerbose(() -> request.getEndpoint().toString())).method(request.getHttpMethod().name()).body(SpansContainer.callIfVerbose(() -> SpansContainer.extractBodyFromRequest(request))).build()).response(HttpSpan.HttpData.builder().headers(SpansContainer.callIfVerbose(() -> SpansContainer.extractHeaders(response.getHttpResponse().getHeaders()))).body(SpansContainer.callIfVerbose(() -> SpansContainer.extractBodyFromResponse(response))).statusCode(response.getHttpResponse().getStatusCode()).build()).build());
        AwsParserFactory.getParser(request.getServiceName()).parse(httpSpan, request, response);
        this.httpSpans.add(httpSpan);
    }

    private static String extractHeaders(Map<String, String> headers) {
        return JsonUtils.getObjectAsJsonString(headers);
    }

    private static String extractHeaders(Header[] headers) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (headers != null) {
            for (Header header : headers) {
                headersMap.put(header.getName(), header.getValue());
            }
        }
        return SpansContainer.extractHeaders(headersMap);
    }

    protected static String extractBodyFromRequest(Request<?> request) {
        return SpansContainer.extractBodyFromRequest(request.getContent());
    }

    protected static String extractBodyFromRequest(HttpUriRequest request) throws Exception {
        HttpEntity entity;
        if (request instanceof HttpEntityEnclosingRequestBase && (entity = ((HttpEntityEnclosingRequestBase)request).getEntity()) != null) {
            return SpansContainer.extractBodyFromRequest(entity.getContent());
        }
        return null;
    }

    protected static String extractBodyFromRequest(InputStream stream) {
        return StringUtils.extractStringForStream(stream, MAX_STRING_SIZE);
    }

    protected static String extractBodyFromResponse(HttpResponse response) throws IOException {
        return StringUtils.extractStringForStream(response.getEntity() != null ? response.getEntity().getContent() : null, MAX_STRING_SIZE);
    }

    protected static String extractBodyFromResponse(Response response) {
        return response.getAwsResponse() != null ? JsonUtils.getObjectAsJsonString(response.getAwsResponse()) : null;
    }

    public String getPatchedRoot() {
        return String.format("Root=%s-0000%s-%s%s", AwsUtils.extractAwsTraceRoot(this.awsTracerId), StringUtils.randomStringAndNumbers(4), AwsUtils.extractAwsTraceTransactionId(this.awsTracerId), AwsUtils.extractAwsTraceSuffix(this.awsTracerId));
    }

    protected static <T> T callIfVerbose(Callable<T> method) {
        if (!Configuration.getInstance().isLumigoVerboseMode()) {
            return null;
        }
        try {
            return method.call();
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Failed to call method");
            return null;
        }
    }

    private Object prepareToSend(Object span, boolean hasError) {
        return this.reduceSpanSize(span, hasError);
    }

    private List<Object> prepareToSend(List<Object> spans, boolean hasError) {
        for (Object span : spans) {
            this.reduceSpanSize(span, hasError);
        }
        return spans;
    }

    public Object reduceSpanSize(Object span, boolean hasError) {
        int maxFieldSize;
        int n = maxFieldSize = hasError ? Configuration.getInstance().maxSpanFieldSizeWhenError() : Configuration.getInstance().maxSpanFieldSize();
        if (span instanceof Span) {
            Span functionSpan = (Span)span;
            functionSpan.setEnvs(StringUtils.getMaxSizeString(functionSpan.getEnvs(), Configuration.getInstance().maxSpanFieldSize()));
            functionSpan.setReturn_value(StringUtils.getMaxSizeString(functionSpan.getReturn_value(), maxFieldSize));
            functionSpan.setEvent(StringUtils.getMaxSizeString(functionSpan.getEvent(), maxFieldSize));
        } else if (span instanceof HttpSpan) {
            HttpSpan httpSpan = (HttpSpan)span;
            httpSpan.getInfo().getHttpInfo().getRequest().setHeaders(StringUtils.getMaxSizeString(httpSpan.getInfo().getHttpInfo().getRequest().getHeaders(), maxFieldSize));
            httpSpan.getInfo().getHttpInfo().getRequest().setBody(StringUtils.getMaxSizeString(httpSpan.getInfo().getHttpInfo().getRequest().getBody(), maxFieldSize));
            httpSpan.getInfo().getHttpInfo().getResponse().setHeaders(StringUtils.getMaxSizeString(httpSpan.getInfo().getHttpInfo().getResponse().getHeaders(), maxFieldSize));
            httpSpan.getInfo().getHttpInfo().getResponse().setBody(StringUtils.getMaxSizeString(httpSpan.getInfo().getHttpInfo().getResponse().getBody(), maxFieldSize));
        }
        return span;
    }
}

