/*
 * Decompiled with CFR 0.152.
 */
package io.lumigo.core.configuration;

import io.lumigo.core.instrumentation.agent.Installer;
import io.lumigo.core.utils.EnvUtil;
import io.lumigo.handlers.LumigoConfiguration;
import java.time.Duration;
import java.util.Locale;
import org.pmw.tinylog.Configurator;
import org.pmw.tinylog.Level;
import org.pmw.tinylog.Logger;
import org.pmw.tinylog.writers.ConsoleWriter;
import org.pmw.tinylog.writers.Writer;

public class Configuration {
    private static final String EDGE_PREFIX = "https://";
    private static final String EDGE_DEFAULT_URL = "%s.lumigo-tracer-edge.golumigo.com";
    private static final String EDGE_SUFFIX = "/api/spans";
    public static final String TOKEN_KEY = "LUMIGO_TRACER_TOKEN";
    public static final String TRACER_HOST_KEY = "LUMIGO_TRACER_HOST";
    public static final String DEBUG_KEY = "LUMIGO_DEBUG";
    public static final String REGION_KEY = "AWS_REGION";
    public static final String LUMIGO_VERBOSE = "LUMIGO_VERBOSE";
    public static final String REPORTER_TIMEOUT = "LUMIGO_REPORTER_TIMEOUT";
    public static final String LUMIGO_KILL_SWITCH = "LUMIGO_SWITCH_OFF";
    public static final String LUMIGO_MAX_ENTRY_SIZE = "LUMIGO_MAX_ENTRY_SIZE";
    public static final String LUMIGO_MAX_RESPONSE_SIZE = "LUMIGO_MAX_RESPONSE_SIZE";
    public static final String LUMIGO_MAX_SIZE_FOR_REQUEST = "LUMIGO_MAX_SIZE_FOR_REQUEST";
    public static final String LUMIGO_INSTRUMENTATION = "LUMIGO_INSTRUMENTATION";
    private static Configuration instance;
    private LumigoConfiguration inlineConf;
    private EnvUtil envUtil = new EnvUtil();

    public static void init(LumigoConfiguration lumigoConfiguration) {
        Configuration.getInstance().inlineConf = lumigoConfiguration == null ? LumigoConfiguration.builder().build() : lumigoConfiguration;
        if (!Configuration.getInstance().inlineConf.getLazyLoading().booleanValue()) {
            Logger.info((String)"Lazy load was set as false, install agent now");
            Installer.install();
        }
    }

    private Configuration() {
        this.inlineConf = LumigoConfiguration.builder().build();
    }

    public static synchronized Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
            Configurator.currentConfig().writer((Writer)new ConsoleWriter()).locale(Locale.US).level(instance.getLogLevel()).maxStackTraceElements(-1).formatPattern("{date:yyyy-MM-dd HH:mm:ss} {level} [thread-{thread}] {class}.{method}() - {message}").activate();
        }
        return instance;
    }

    public String getLumigoToken() {
        return this.inlineConf.getToken() != null ? this.inlineConf.getToken() : this.envUtil.getEnv(TOKEN_KEY);
    }

    public String getLumigoEdge() {
        String url;
        String string = url = this.inlineConf.getEdgeHost() != null ? this.inlineConf.getEdgeHost() : this.envUtil.getEnv(TRACER_HOST_KEY);
        if (url == null) {
            url = String.format(EDGE_DEFAULT_URL, this.envUtil.getEnv(REGION_KEY));
        }
        return EDGE_PREFIX + url + EDGE_SUFFIX;
    }

    public Level getLogLevel() {
        return this.envUtil.getBooleanEnv(DEBUG_KEY, false) != false ? Level.DEBUG : Level.OFF;
    }

    public String getLumigoTracerVersion() {
        return "1.0.40";
    }

    public Duration getLumigoTimeout() {
        String timeout = this.envUtil.getEnv(REPORTER_TIMEOUT);
        if (timeout != null) {
            return Duration.ofMillis(Long.parseLong(timeout));
        }
        return Duration.ofMillis(3000L);
    }

    public int maxSpanFieldSize() {
        return this.envUtil.getIntegerEnv(LUMIGO_MAX_ENTRY_SIZE, 1024);
    }

    public int maxSpanFieldSizeWhenError() {
        return this.maxSpanFieldSize() * 10;
    }

    public boolean isAwsEnvironment() {
        return this.envUtil.getEnv("LAMBDA_RUNTIME_DIR") != null;
    }

    public boolean isLumigoVerboseMode() {
        return this.inlineConf.getVerbose() != null ? this.inlineConf.getVerbose() : this.envUtil.getBooleanEnv(LUMIGO_VERBOSE, true);
    }

    public boolean isKillingSwitchActivated() {
        return this.inlineConf.getKillSwitch() != null ? this.inlineConf.getKillSwitch() : this.envUtil.getBooleanEnv(LUMIGO_KILL_SWITCH, false);
    }

    public boolean isLumigoHost(String host) {
        return host.contains(this.getLumigoEdge().replace(EDGE_PREFIX, "").replace(EDGE_SUFFIX, ""));
    }

    public boolean isAwsHost(String host) {
        return host.endsWith("amazonaws.com");
    }

    public boolean isInstrumentationEnabled() {
        return this.envUtil.getBooleanEnv(LUMIGO_INSTRUMENTATION, true);
    }

    public int maxRequestSize() {
        return this.envUtil.getIntegerEnv(LUMIGO_MAX_SIZE_FOR_REQUEST, this.envUtil.getIntegerEnv(LUMIGO_MAX_RESPONSE_SIZE, 512000));
    }

    public void setEnvUtil(EnvUtil envUtil) {
        this.envUtil = envUtil;
    }
}

